/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iam.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about the effect that Organizations has on a policy simulation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class OrganizationsDecisionDetail implements SdkPojo, Serializable,
        ToCopyableBuilder<OrganizationsDecisionDetail.Builder, OrganizationsDecisionDetail> {
    private static final SdkField<Boolean> ALLOWED_BY_ORGANIZATIONS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(OrganizationsDecisionDetail::allowedByOrganizations)).setter(setter(Builder::allowedByOrganizations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllowedByOrganizations").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(ALLOWED_BY_ORGANIZATIONS_FIELD));

    private static final long serialVersionUID = 1L;

    private final Boolean allowedByOrganizations;

    private OrganizationsDecisionDetail(BuilderImpl builder) {
        this.allowedByOrganizations = builder.allowedByOrganizations;
    }

    /**
     * <p>
     * Specifies whether the simulated operation is allowed by the Organizations service control policies that impact
     * the simulated user's account.
     * </p>
     * 
     * @return Specifies whether the simulated operation is allowed by the Organizations service control policies that
     *         impact the simulated user's account.
     */
    public Boolean allowedByOrganizations() {
        return allowedByOrganizations;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(allowedByOrganizations());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OrganizationsDecisionDetail)) {
            return false;
        }
        OrganizationsDecisionDetail other = (OrganizationsDecisionDetail) obj;
        return Objects.equals(allowedByOrganizations(), other.allowedByOrganizations());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("OrganizationsDecisionDetail").add("AllowedByOrganizations", allowedByOrganizations()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AllowedByOrganizations":
            return Optional.ofNullable(clazz.cast(allowedByOrganizations()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<OrganizationsDecisionDetail, T> g) {
        return obj -> g.apply((OrganizationsDecisionDetail) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, OrganizationsDecisionDetail> {
        /**
         * <p>
         * Specifies whether the simulated operation is allowed by the Organizations service control policies that
         * impact the simulated user's account.
         * </p>
         * 
         * @param allowedByOrganizations
         *        Specifies whether the simulated operation is allowed by the Organizations service control policies
         *        that impact the simulated user's account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allowedByOrganizations(Boolean allowedByOrganizations);
    }

    static final class BuilderImpl implements Builder {
        private Boolean allowedByOrganizations;

        private BuilderImpl() {
        }

        private BuilderImpl(OrganizationsDecisionDetail model) {
            allowedByOrganizations(model.allowedByOrganizations);
        }

        public final Boolean getAllowedByOrganizations() {
            return allowedByOrganizations;
        }

        @Override
        public final Builder allowedByOrganizations(Boolean allowedByOrganizations) {
            this.allowedByOrganizations = allowedByOrganizations;
            return this;
        }

        public final void setAllowedByOrganizations(Boolean allowedByOrganizations) {
            this.allowedByOrganizations = allowedByOrganizations;
        }

        @Override
        public OrganizationsDecisionDetail build() {
            return new OrganizationsDecisionDetail(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
