/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iam.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListUserTagsResponse extends IamResponse implements
        ToCopyableBuilder<ListUserTagsResponse.Builder, ListUserTagsResponse> {
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .getter(getter(ListUserTagsResponse::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Boolean> IS_TRUNCATED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(ListUserTagsResponse::isTruncated)).setter(setter(Builder::isTruncated))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsTruncated").build()).build();

    private static final SdkField<String> MARKER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListUserTagsResponse::marker)).setter(setter(Builder::marker))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TAGS_FIELD,
            IS_TRUNCATED_FIELD, MARKER_FIELD));

    private final List<Tag> tags;

    private final Boolean isTruncated;

    private final String marker;

    private ListUserTagsResponse(BuilderImpl builder) {
        super(builder);
        this.tags = builder.tags;
        this.isTruncated = builder.isTruncated;
        this.marker = builder.marker;
    }

    /**
     * Returns true if the Tags property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of tags that are currently attached to the user. Each tag consists of a key name and an associated
     * value. If no tags are attached to the specified user, the response contains an empty list.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTags()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The list of tags that are currently attached to the user. Each tag consists of a key name and an
     *         associated value. If no tags are attached to the specified user, the response contains an empty list.
     */
    public List<Tag> tags() {
        return tags;
    }

    /**
     * <p>
     * A flag that indicates whether there are more items to return. If your results were truncated, you can use the
     * <code>Marker</code> request parameter to make a subsequent pagination request that retrieves more items. Note
     * that IAM might return fewer than the <code>MaxItems</code> number of results even when more results are
     * available. Check <code>IsTruncated</code> after every call to ensure that you receive all of your results.
     * </p>
     * 
     * @return A flag that indicates whether there are more items to return. If your results were truncated, you can use
     *         the <code>Marker</code> request parameter to make a subsequent pagination request that retrieves more
     *         items. Note that IAM might return fewer than the <code>MaxItems</code> number of results even when more
     *         results are available. Check <code>IsTruncated</code> after every call to ensure that you receive all of
     *         your results.
     */
    public Boolean isTruncated() {
        return isTruncated;
    }

    /**
     * <p>
     * When <code>IsTruncated</code> is <code>true</code>, this element is present and contains the value to use for the
     * <code>Marker</code> parameter in a subsequent pagination request.
     * </p>
     * 
     * @return When <code>IsTruncated</code> is <code>true</code>, this element is present and contains the value to use
     *         for the <code>Marker</code> parameter in a subsequent pagination request.
     */
    public String marker() {
        return marker;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(tags());
        hashCode = 31 * hashCode + Objects.hashCode(isTruncated());
        hashCode = 31 * hashCode + Objects.hashCode(marker());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListUserTagsResponse)) {
            return false;
        }
        ListUserTagsResponse other = (ListUserTagsResponse) obj;
        return Objects.equals(tags(), other.tags()) && Objects.equals(isTruncated(), other.isTruncated())
                && Objects.equals(marker(), other.marker());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ListUserTagsResponse").add("Tags", tags()).add("IsTruncated", isTruncated())
                .add("Marker", marker()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "IsTruncated":
            return Optional.ofNullable(clazz.cast(isTruncated()));
        case "Marker":
            return Optional.ofNullable(clazz.cast(marker()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListUserTagsResponse, T> g) {
        return obj -> g.apply((ListUserTagsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IamResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListUserTagsResponse> {
        /**
         * <p>
         * The list of tags that are currently attached to the user. Each tag consists of a key name and an associated
         * value. If no tags are attached to the specified user, the response contains an empty list.
         * </p>
         * 
         * @param tags
         *        The list of tags that are currently attached to the user. Each tag consists of a key name and an
         *        associated value. If no tags are attached to the specified user, the response contains an empty list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * The list of tags that are currently attached to the user. Each tag consists of a key name and an associated
         * value. If no tags are attached to the specified user, the response contains an empty list.
         * </p>
         * 
         * @param tags
         *        The list of tags that are currently attached to the user. Each tag consists of a key name and an
         *        associated value. If no tags are attached to the specified user, the response contains an empty list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * The list of tags that are currently attached to the user. Each tag consists of a key name and an associated
         * value. If no tags are attached to the specified user, the response contains an empty list.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Tag>.Builder} avoiding the need to create
         * one manually via {@link List<Tag>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Tag>.Builder#build()} is called immediately and its result
         * is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link List<Tag>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(List<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        /**
         * <p>
         * A flag that indicates whether there are more items to return. If your results were truncated, you can use the
         * <code>Marker</code> request parameter to make a subsequent pagination request that retrieves more items. Note
         * that IAM might return fewer than the <code>MaxItems</code> number of results even when more results are
         * available. Check <code>IsTruncated</code> after every call to ensure that you receive all of your results.
         * </p>
         * 
         * @param isTruncated
         *        A flag that indicates whether there are more items to return. If your results were truncated, you can
         *        use the <code>Marker</code> request parameter to make a subsequent pagination request that retrieves
         *        more items. Note that IAM might return fewer than the <code>MaxItems</code> number of results even
         *        when more results are available. Check <code>IsTruncated</code> after every call to ensure that you
         *        receive all of your results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isTruncated(Boolean isTruncated);

        /**
         * <p>
         * When <code>IsTruncated</code> is <code>true</code>, this element is present and contains the value to use for
         * the <code>Marker</code> parameter in a subsequent pagination request.
         * </p>
         * 
         * @param marker
         *        When <code>IsTruncated</code> is <code>true</code>, this element is present and contains the value to
         *        use for the <code>Marker</code> parameter in a subsequent pagination request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder marker(String marker);
    }

    static final class BuilderImpl extends IamResponse.BuilderImpl implements Builder {
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private Boolean isTruncated;

        private String marker;

        private BuilderImpl() {
        }

        private BuilderImpl(ListUserTagsResponse model) {
            super(model);
            tags(model.tags);
            isTruncated(model.isTruncated);
            marker(model.marker);
        }

        public final Collection<Tag.Builder> getTags() {
            return tags != null ? tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = _tagListTypeCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = _tagListTypeCopier.copyFromBuilder(tags);
        }

        public final Boolean getIsTruncated() {
            return isTruncated;
        }

        @Override
        public final Builder isTruncated(Boolean isTruncated) {
            this.isTruncated = isTruncated;
            return this;
        }

        public final void setIsTruncated(Boolean isTruncated) {
            this.isTruncated = isTruncated;
        }

        public final String getMarker() {
            return marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        public ListUserTagsResponse build() {
            return new ListUserTagsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
