/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iam.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListPoliciesRequest extends IamRequest implements
        ToCopyableBuilder<ListPoliciesRequest.Builder, ListPoliciesRequest> {
    private static final SdkField<String> SCOPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListPoliciesRequest::scopeAsString)).setter(setter(Builder::scope))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Scope").build()).build();

    private static final SdkField<Boolean> ONLY_ATTACHED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(ListPoliciesRequest::onlyAttached)).setter(setter(Builder::onlyAttached))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OnlyAttached").build()).build();

    private static final SdkField<String> PATH_PREFIX_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListPoliciesRequest::pathPrefix)).setter(setter(Builder::pathPrefix))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PathPrefix").build()).build();

    private static final SdkField<String> POLICY_USAGE_FILTER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListPoliciesRequest::policyUsageFilterAsString)).setter(setter(Builder::policyUsageFilter))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PolicyUsageFilter").build()).build();

    private static final SdkField<String> MARKER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListPoliciesRequest::marker)).setter(setter(Builder::marker))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()).build();

    private static final SdkField<Integer> MAX_ITEMS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(ListPoliciesRequest::maxItems)).setter(setter(Builder::maxItems))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxItems").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SCOPE_FIELD,
            ONLY_ATTACHED_FIELD, PATH_PREFIX_FIELD, POLICY_USAGE_FILTER_FIELD, MARKER_FIELD, MAX_ITEMS_FIELD));

    private final String scope;

    private final Boolean onlyAttached;

    private final String pathPrefix;

    private final String policyUsageFilter;

    private final String marker;

    private final Integer maxItems;

    private ListPoliciesRequest(BuilderImpl builder) {
        super(builder);
        this.scope = builder.scope;
        this.onlyAttached = builder.onlyAttached;
        this.pathPrefix = builder.pathPrefix;
        this.policyUsageFilter = builder.policyUsageFilter;
        this.marker = builder.marker;
        this.maxItems = builder.maxItems;
    }

    /**
     * <p>
     * The scope to use for filtering the results.
     * </p>
     * <p>
     * To list only AWS managed policies, set <code>Scope</code> to <code>AWS</code>. To list only the customer managed
     * policies in your AWS account, set <code>Scope</code> to <code>Local</code>.
     * </p>
     * <p>
     * This parameter is optional. If it is not included, or if it is set to <code>All</code>, all policies are
     * returned.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #scope} will return
     * {@link PolicyScopeType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #scopeAsString}.
     * </p>
     * 
     * @return The scope to use for filtering the results.</p>
     *         <p>
     *         To list only AWS managed policies, set <code>Scope</code> to <code>AWS</code>. To list only the customer
     *         managed policies in your AWS account, set <code>Scope</code> to <code>Local</code>.
     *         </p>
     *         <p>
     *         This parameter is optional. If it is not included, or if it is set to <code>All</code>, all policies are
     *         returned.
     * @see PolicyScopeType
     */
    public PolicyScopeType scope() {
        return PolicyScopeType.fromValue(scope);
    }

    /**
     * <p>
     * The scope to use for filtering the results.
     * </p>
     * <p>
     * To list only AWS managed policies, set <code>Scope</code> to <code>AWS</code>. To list only the customer managed
     * policies in your AWS account, set <code>Scope</code> to <code>Local</code>.
     * </p>
     * <p>
     * This parameter is optional. If it is not included, or if it is set to <code>All</code>, all policies are
     * returned.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #scope} will return
     * {@link PolicyScopeType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #scopeAsString}.
     * </p>
     * 
     * @return The scope to use for filtering the results.</p>
     *         <p>
     *         To list only AWS managed policies, set <code>Scope</code> to <code>AWS</code>. To list only the customer
     *         managed policies in your AWS account, set <code>Scope</code> to <code>Local</code>.
     *         </p>
     *         <p>
     *         This parameter is optional. If it is not included, or if it is set to <code>All</code>, all policies are
     *         returned.
     * @see PolicyScopeType
     */
    public String scopeAsString() {
        return scope;
    }

    /**
     * <p>
     * A flag to filter the results to only the attached policies.
     * </p>
     * <p>
     * When <code>OnlyAttached</code> is <code>true</code>, the returned list contains only the policies that are
     * attached to an IAM user, group, or role. When <code>OnlyAttached</code> is <code>false</code>, or when the
     * parameter is not included, all policies are returned.
     * </p>
     * 
     * @return A flag to filter the results to only the attached policies.</p>
     *         <p>
     *         When <code>OnlyAttached</code> is <code>true</code>, the returned list contains only the policies that
     *         are attached to an IAM user, group, or role. When <code>OnlyAttached</code> is <code>false</code>, or
     *         when the parameter is not included, all policies are returned.
     */
    public Boolean onlyAttached() {
        return onlyAttached;
    }

    /**
     * <p>
     * The path prefix for filtering the results. This parameter is optional. If it is not included, it defaults to a
     * slash (/), listing all policies. This parameter allows (through its <a
     * href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of either a forward
     * slash (/) by itself or a string that must begin and end with forward slashes. In addition, it can contain any
     * ASCII character from the ! (<code>\u0021</code>) through the DEL character (<code>\u007F</code>), including most
     * punctuation characters, digits, and upper and lowercased letters.
     * </p>
     * 
     * @return The path prefix for filtering the results. This parameter is optional. If it is not included, it defaults
     *         to a slash (/), listing all policies. This parameter allows (through its <a
     *         href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of either a
     *         forward slash (/) by itself or a string that must begin and end with forward slashes. In addition, it can
     *         contain any ASCII character from the ! (<code>\u0021</code>) through the DEL character (
     *         <code>\u007F</code>), including most punctuation characters, digits, and upper and lowercased letters.
     */
    public String pathPrefix() {
        return pathPrefix;
    }

    /**
     * <p>
     * The policy usage method to use for filtering the results.
     * </p>
     * <p>
     * To list only permissions policies, set <code>PolicyUsageFilter</code> to <code>PermissionsPolicy</code>. To list
     * only the policies used to set permissions boundaries, set the value to <code>PermissionsBoundary</code>.
     * </p>
     * <p>
     * This parameter is optional. If it is not included, all policies are returned.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #policyUsageFilter}
     * will return {@link PolicyUsageType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #policyUsageFilterAsString}.
     * </p>
     * 
     * @return The policy usage method to use for filtering the results.</p>
     *         <p>
     *         To list only permissions policies, set <code>PolicyUsageFilter</code> to <code>PermissionsPolicy</code>.
     *         To list only the policies used to set permissions boundaries, set the value to 
     *         <code>PermissionsBoundary</code>.
     *         </p>
     *         <p>
     *         This parameter is optional. If it is not included, all policies are returned.
     * @see PolicyUsageType
     */
    public PolicyUsageType policyUsageFilter() {
        return PolicyUsageType.fromValue(policyUsageFilter);
    }

    /**
     * <p>
     * The policy usage method to use for filtering the results.
     * </p>
     * <p>
     * To list only permissions policies, set <code>PolicyUsageFilter</code> to <code>PermissionsPolicy</code>. To list
     * only the policies used to set permissions boundaries, set the value to <code>PermissionsBoundary</code>.
     * </p>
     * <p>
     * This parameter is optional. If it is not included, all policies are returned.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #policyUsageFilter}
     * will return {@link PolicyUsageType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #policyUsageFilterAsString}.
     * </p>
     * 
     * @return The policy usage method to use for filtering the results.</p>
     *         <p>
     *         To list only permissions policies, set <code>PolicyUsageFilter</code> to <code>PermissionsPolicy</code>.
     *         To list only the policies used to set permissions boundaries, set the value to 
     *         <code>PermissionsBoundary</code>.
     *         </p>
     *         <p>
     *         This parameter is optional. If it is not included, all policies are returned.
     * @see PolicyUsageType
     */
    public String policyUsageFilterAsString() {
        return policyUsageFilter;
    }

    /**
     * <p>
     * Use this parameter only when paginating results and only after you receive a response indicating that the results
     * are truncated. Set it to the value of the <code>Marker</code> element in the response that you received to
     * indicate where the next call should start.
     * </p>
     * 
     * @return Use this parameter only when paginating results and only after you receive a response indicating that the
     *         results are truncated. Set it to the value of the <code>Marker</code> element in the response that you
     *         received to indicate where the next call should start.
     */
    public String marker() {
        return marker;
    }

    /**
     * <p>
     * Use this only when paginating results to indicate the maximum number of items you want in the response. If
     * additional items exist beyond the maximum you specify, the <code>IsTruncated</code> response element is
     * <code>true</code>.
     * </p>
     * <p>
     * If you do not include this parameter, the number of items defaults to 100. Note that IAM might return fewer
     * results, even when there are more results available. In that case, the <code>IsTruncated</code> response element
     * returns <code>true</code>, and <code>Marker</code> contains a value to include in the subsequent call that tells
     * the service where to continue from.
     * </p>
     * 
     * @return Use this only when paginating results to indicate the maximum number of items you want in the response.
     *         If additional items exist beyond the maximum you specify, the <code>IsTruncated</code> response element
     *         is <code>true</code>.</p>
     *         <p>
     *         If you do not include this parameter, the number of items defaults to 100. Note that IAM might return
     *         fewer results, even when there are more results available. In that case, the <code>IsTruncated</code>
     *         response element returns <code>true</code>, and <code>Marker</code> contains a value to include in the
     *         subsequent call that tells the service where to continue from.
     */
    public Integer maxItems() {
        return maxItems;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(scopeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(onlyAttached());
        hashCode = 31 * hashCode + Objects.hashCode(pathPrefix());
        hashCode = 31 * hashCode + Objects.hashCode(policyUsageFilterAsString());
        hashCode = 31 * hashCode + Objects.hashCode(marker());
        hashCode = 31 * hashCode + Objects.hashCode(maxItems());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListPoliciesRequest)) {
            return false;
        }
        ListPoliciesRequest other = (ListPoliciesRequest) obj;
        return Objects.equals(scopeAsString(), other.scopeAsString()) && Objects.equals(onlyAttached(), other.onlyAttached())
                && Objects.equals(pathPrefix(), other.pathPrefix())
                && Objects.equals(policyUsageFilterAsString(), other.policyUsageFilterAsString())
                && Objects.equals(marker(), other.marker()) && Objects.equals(maxItems(), other.maxItems());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ListPoliciesRequest").add("Scope", scopeAsString()).add("OnlyAttached", onlyAttached())
                .add("PathPrefix", pathPrefix()).add("PolicyUsageFilter", policyUsageFilterAsString()).add("Marker", marker())
                .add("MaxItems", maxItems()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Scope":
            return Optional.ofNullable(clazz.cast(scopeAsString()));
        case "OnlyAttached":
            return Optional.ofNullable(clazz.cast(onlyAttached()));
        case "PathPrefix":
            return Optional.ofNullable(clazz.cast(pathPrefix()));
        case "PolicyUsageFilter":
            return Optional.ofNullable(clazz.cast(policyUsageFilterAsString()));
        case "Marker":
            return Optional.ofNullable(clazz.cast(marker()));
        case "MaxItems":
            return Optional.ofNullable(clazz.cast(maxItems()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListPoliciesRequest, T> g) {
        return obj -> g.apply((ListPoliciesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IamRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListPoliciesRequest> {
        /**
         * <p>
         * The scope to use for filtering the results.
         * </p>
         * <p>
         * To list only AWS managed policies, set <code>Scope</code> to <code>AWS</code>. To list only the customer
         * managed policies in your AWS account, set <code>Scope</code> to <code>Local</code>.
         * </p>
         * <p>
         * This parameter is optional. If it is not included, or if it is set to <code>All</code>, all policies are
         * returned.
         * </p>
         * 
         * @param scope
         *        The scope to use for filtering the results.</p>
         *        <p>
         *        To list only AWS managed policies, set <code>Scope</code> to <code>AWS</code>. To list only the
         *        customer managed policies in your AWS account, set <code>Scope</code> to <code>Local</code>.
         *        </p>
         *        <p>
         *        This parameter is optional. If it is not included, or if it is set to <code>All</code>, all policies
         *        are returned.
         * @see PolicyScopeType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PolicyScopeType
         */
        Builder scope(String scope);

        /**
         * <p>
         * The scope to use for filtering the results.
         * </p>
         * <p>
         * To list only AWS managed policies, set <code>Scope</code> to <code>AWS</code>. To list only the customer
         * managed policies in your AWS account, set <code>Scope</code> to <code>Local</code>.
         * </p>
         * <p>
         * This parameter is optional. If it is not included, or if it is set to <code>All</code>, all policies are
         * returned.
         * </p>
         * 
         * @param scope
         *        The scope to use for filtering the results.</p>
         *        <p>
         *        To list only AWS managed policies, set <code>Scope</code> to <code>AWS</code>. To list only the
         *        customer managed policies in your AWS account, set <code>Scope</code> to <code>Local</code>.
         *        </p>
         *        <p>
         *        This parameter is optional. If it is not included, or if it is set to <code>All</code>, all policies
         *        are returned.
         * @see PolicyScopeType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PolicyScopeType
         */
        Builder scope(PolicyScopeType scope);

        /**
         * <p>
         * A flag to filter the results to only the attached policies.
         * </p>
         * <p>
         * When <code>OnlyAttached</code> is <code>true</code>, the returned list contains only the policies that are
         * attached to an IAM user, group, or role. When <code>OnlyAttached</code> is <code>false</code>, or when the
         * parameter is not included, all policies are returned.
         * </p>
         * 
         * @param onlyAttached
         *        A flag to filter the results to only the attached policies.</p>
         *        <p>
         *        When <code>OnlyAttached</code> is <code>true</code>, the returned list contains only the policies that
         *        are attached to an IAM user, group, or role. When <code>OnlyAttached</code> is <code>false</code>, or
         *        when the parameter is not included, all policies are returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder onlyAttached(Boolean onlyAttached);

        /**
         * <p>
         * The path prefix for filtering the results. This parameter is optional. If it is not included, it defaults to
         * a slash (/), listing all policies. This parameter allows (through its <a
         * href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of either a
         * forward slash (/) by itself or a string that must begin and end with forward slashes. In addition, it can
         * contain any ASCII character from the ! (<code>\u0021</code>) through the DEL character (<code>\u007F</code>),
         * including most punctuation characters, digits, and upper and lowercased letters.
         * </p>
         * 
         * @param pathPrefix
         *        The path prefix for filtering the results. This parameter is optional. If it is not included, it
         *        defaults to a slash (/), listing all policies. This parameter allows (through its <a
         *        href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of either
         *        a forward slash (/) by itself or a string that must begin and end with forward slashes. In addition,
         *        it can contain any ASCII character from the ! (<code>\u0021</code>) through the DEL character (
         *        <code>\u007F</code>), including most punctuation characters, digits, and upper and lowercased letters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pathPrefix(String pathPrefix);

        /**
         * <p>
         * The policy usage method to use for filtering the results.
         * </p>
         * <p>
         * To list only permissions policies, set <code>PolicyUsageFilter</code> to <code>PermissionsPolicy</code>. To
         * list only the policies used to set permissions boundaries, set the value to <code>PermissionsBoundary</code>.
         * </p>
         * <p>
         * This parameter is optional. If it is not included, all policies are returned.
         * </p>
         * 
         * @param policyUsageFilter
         *        The policy usage method to use for filtering the results.</p>
         *        <p>
         *        To list only permissions policies, set <code>PolicyUsageFilter</code> to 
         *        <code>PermissionsPolicy</code>. To list only the policies used to set permissions boundaries, set the
         *        value to <code>PermissionsBoundary</code>.
         *        </p>
         *        <p>
         *        This parameter is optional. If it is not included, all policies are returned.
         * @see PolicyUsageType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PolicyUsageType
         */
        Builder policyUsageFilter(String policyUsageFilter);

        /**
         * <p>
         * The policy usage method to use for filtering the results.
         * </p>
         * <p>
         * To list only permissions policies, set <code>PolicyUsageFilter</code> to <code>PermissionsPolicy</code>. To
         * list only the policies used to set permissions boundaries, set the value to <code>PermissionsBoundary</code>.
         * </p>
         * <p>
         * This parameter is optional. If it is not included, all policies are returned.
         * </p>
         * 
         * @param policyUsageFilter
         *        The policy usage method to use for filtering the results.</p>
         *        <p>
         *        To list only permissions policies, set <code>PolicyUsageFilter</code> to 
         *        <code>PermissionsPolicy</code>. To list only the policies used to set permissions boundaries, set the
         *        value to <code>PermissionsBoundary</code>.
         *        </p>
         *        <p>
         *        This parameter is optional. If it is not included, all policies are returned.
         * @see PolicyUsageType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PolicyUsageType
         */
        Builder policyUsageFilter(PolicyUsageType policyUsageFilter);

        /**
         * <p>
         * Use this parameter only when paginating results and only after you receive a response indicating that the
         * results are truncated. Set it to the value of the <code>Marker</code> element in the response that you
         * received to indicate where the next call should start.
         * </p>
         * 
         * @param marker
         *        Use this parameter only when paginating results and only after you receive a response indicating that
         *        the results are truncated. Set it to the value of the <code>Marker</code> element in the response that
         *        you received to indicate where the next call should start.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder marker(String marker);

        /**
         * <p>
         * Use this only when paginating results to indicate the maximum number of items you want in the response. If
         * additional items exist beyond the maximum you specify, the <code>IsTruncated</code> response element is
         * <code>true</code>.
         * </p>
         * <p>
         * If you do not include this parameter, the number of items defaults to 100. Note that IAM might return fewer
         * results, even when there are more results available. In that case, the <code>IsTruncated</code> response
         * element returns <code>true</code>, and <code>Marker</code> contains a value to include in the subsequent call
         * that tells the service where to continue from.
         * </p>
         * 
         * @param maxItems
         *        Use this only when paginating results to indicate the maximum number of items you want in the
         *        response. If additional items exist beyond the maximum you specify, the <code>IsTruncated</code>
         *        response element is <code>true</code>.</p>
         *        <p>
         *        If you do not include this parameter, the number of items defaults to 100. Note that IAM might return
         *        fewer results, even when there are more results available. In that case, the <code>IsTruncated</code>
         *        response element returns <code>true</code>, and <code>Marker</code> contains a value to include in the
         *        subsequent call that tells the service where to continue from.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxItems(Integer maxItems);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends IamRequest.BuilderImpl implements Builder {
        private String scope;

        private Boolean onlyAttached;

        private String pathPrefix;

        private String policyUsageFilter;

        private String marker;

        private Integer maxItems;

        private BuilderImpl() {
        }

        private BuilderImpl(ListPoliciesRequest model) {
            super(model);
            scope(model.scope);
            onlyAttached(model.onlyAttached);
            pathPrefix(model.pathPrefix);
            policyUsageFilter(model.policyUsageFilter);
            marker(model.marker);
            maxItems(model.maxItems);
        }

        public final String getScopeAsString() {
            return scope;
        }

        @Override
        public final Builder scope(String scope) {
            this.scope = scope;
            return this;
        }

        @Override
        public final Builder scope(PolicyScopeType scope) {
            this.scope(scope == null ? null : scope.toString());
            return this;
        }

        public final void setScope(String scope) {
            this.scope = scope;
        }

        public final Boolean getOnlyAttached() {
            return onlyAttached;
        }

        @Override
        public final Builder onlyAttached(Boolean onlyAttached) {
            this.onlyAttached = onlyAttached;
            return this;
        }

        public final void setOnlyAttached(Boolean onlyAttached) {
            this.onlyAttached = onlyAttached;
        }

        public final String getPathPrefix() {
            return pathPrefix;
        }

        @Override
        public final Builder pathPrefix(String pathPrefix) {
            this.pathPrefix = pathPrefix;
            return this;
        }

        public final void setPathPrefix(String pathPrefix) {
            this.pathPrefix = pathPrefix;
        }

        public final String getPolicyUsageFilterAsString() {
            return policyUsageFilter;
        }

        @Override
        public final Builder policyUsageFilter(String policyUsageFilter) {
            this.policyUsageFilter = policyUsageFilter;
            return this;
        }

        @Override
        public final Builder policyUsageFilter(PolicyUsageType policyUsageFilter) {
            this.policyUsageFilter(policyUsageFilter == null ? null : policyUsageFilter.toString());
            return this;
        }

        public final void setPolicyUsageFilter(String policyUsageFilter) {
            this.policyUsageFilter = policyUsageFilter;
        }

        public final String getMarker() {
            return marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        public final Integer getMaxItems() {
            return maxItems;
        }

        @Override
        public final Builder maxItems(Integer maxItems) {
            this.maxItems = maxItems;
            return this;
        }

        public final void setMaxItems(Integer maxItems) {
            this.maxItems = maxItems;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListPoliciesRequest build() {
            return new ListPoliciesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
