/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iam.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListPoliciesGrantingServiceAccessRequest extends IamRequest implements
        ToCopyableBuilder<ListPoliciesGrantingServiceAccessRequest.Builder, ListPoliciesGrantingServiceAccessRequest> {
    private static final SdkField<String> MARKER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListPoliciesGrantingServiceAccessRequest::marker)).setter(setter(Builder::marker))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()).build();

    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListPoliciesGrantingServiceAccessRequest::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()).build();

    private static final SdkField<List<String>> SERVICE_NAMESPACES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(ListPoliciesGrantingServiceAccessRequest::serviceNamespaces))
            .setter(setter(Builder::serviceNamespaces))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceNamespaces").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MARKER_FIELD, ARN_FIELD,
            SERVICE_NAMESPACES_FIELD));

    private final String marker;

    private final String arn;

    private final List<String> serviceNamespaces;

    private ListPoliciesGrantingServiceAccessRequest(BuilderImpl builder) {
        super(builder);
        this.marker = builder.marker;
        this.arn = builder.arn;
        this.serviceNamespaces = builder.serviceNamespaces;
    }

    /**
     * <p>
     * Use this parameter only when paginating results and only after you receive a response indicating that the results
     * are truncated. Set it to the value of the <code>Marker</code> element in the response that you received to
     * indicate where the next call should start.
     * </p>
     * 
     * @return Use this parameter only when paginating results and only after you receive a response indicating that the
     *         results are truncated. Set it to the value of the <code>Marker</code> element in the response that you
     *         received to indicate where the next call should start.
     */
    public String marker() {
        return marker;
    }

    /**
     * <p>
     * The ARN of the IAM identity (user, group, or role) whose policies you want to list.
     * </p>
     * 
     * @return The ARN of the IAM identity (user, group, or role) whose policies you want to list.
     */
    public String arn() {
        return arn;
    }

    /**
     * Returns true if the ServiceNamespaces property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasServiceNamespaces() {
        return serviceNamespaces != null && !(serviceNamespaces instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The service namespace for the AWS services whose policies you want to list.
     * </p>
     * <p>
     * To learn the service namespace for a service, go to <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_actions-resources-contextkeys.html"
     * >Actions, Resources, and Condition Keys for AWS Services</a> in the <i>IAM User Guide</i>. Choose the name of the
     * service to view details for that service. In the first paragraph, find the service prefix. For example,
     * <code>(service prefix: a4b)</code>. For more information about service namespaces, see <a
     * href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html#genref-aws-service-namespaces"
     * >AWS Service Namespaces</a> in the <i>AWS General Reference</i>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasServiceNamespaces()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The service namespace for the AWS services whose policies you want to list.</p>
     *         <p>
     *         To learn the service namespace for a service, go to <a href=
     *         "https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_actions-resources-contextkeys.html"
     *         >Actions, Resources, and Condition Keys for AWS Services</a> in the <i>IAM User Guide</i>. Choose the
     *         name of the service to view details for that service. In the first paragraph, find the service prefix.
     *         For example, <code>(service prefix: a4b)</code>. For more information about service namespaces, see <a
     *         href=
     *         "https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html#genref-aws-service-namespaces"
     *         >AWS Service Namespaces</a> in the <i>AWS General Reference</i>.
     */
    public List<String> serviceNamespaces() {
        return serviceNamespaces;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(marker());
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(serviceNamespaces());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListPoliciesGrantingServiceAccessRequest)) {
            return false;
        }
        ListPoliciesGrantingServiceAccessRequest other = (ListPoliciesGrantingServiceAccessRequest) obj;
        return Objects.equals(marker(), other.marker()) && Objects.equals(arn(), other.arn())
                && Objects.equals(serviceNamespaces(), other.serviceNamespaces());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ListPoliciesGrantingServiceAccessRequest").add("Marker", marker()).add("Arn", arn())
                .add("ServiceNamespaces", serviceNamespaces()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Marker":
            return Optional.ofNullable(clazz.cast(marker()));
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "ServiceNamespaces":
            return Optional.ofNullable(clazz.cast(serviceNamespaces()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListPoliciesGrantingServiceAccessRequest, T> g) {
        return obj -> g.apply((ListPoliciesGrantingServiceAccessRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IamRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, ListPoliciesGrantingServiceAccessRequest> {
        /**
         * <p>
         * Use this parameter only when paginating results and only after you receive a response indicating that the
         * results are truncated. Set it to the value of the <code>Marker</code> element in the response that you
         * received to indicate where the next call should start.
         * </p>
         * 
         * @param marker
         *        Use this parameter only when paginating results and only after you receive a response indicating that
         *        the results are truncated. Set it to the value of the <code>Marker</code> element in the response that
         *        you received to indicate where the next call should start.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder marker(String marker);

        /**
         * <p>
         * The ARN of the IAM identity (user, group, or role) whose policies you want to list.
         * </p>
         * 
         * @param arn
         *        The ARN of the IAM identity (user, group, or role) whose policies you want to list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The service namespace for the AWS services whose policies you want to list.
         * </p>
         * <p>
         * To learn the service namespace for a service, go to <a href=
         * "https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_actions-resources-contextkeys.html"
         * >Actions, Resources, and Condition Keys for AWS Services</a> in the <i>IAM User Guide</i>. Choose the name of
         * the service to view details for that service. In the first paragraph, find the service prefix. For example,
         * <code>(service prefix: a4b)</code>. For more information about service namespaces, see <a href=
         * "https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html#genref-aws-service-namespaces"
         * >AWS Service Namespaces</a> in the <i>AWS General Reference</i>.
         * </p>
         * 
         * @param serviceNamespaces
         *        The service namespace for the AWS services whose policies you want to list.</p>
         *        <p>
         *        To learn the service namespace for a service, go to <a href=
         *        "https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_actions-resources-contextkeys.html"
         *        >Actions, Resources, and Condition Keys for AWS Services</a> in the <i>IAM User Guide</i>. Choose the
         *        name of the service to view details for that service. In the first paragraph, find the service prefix.
         *        For example, <code>(service prefix: a4b)</code>. For more information about service namespaces, see <a
         *        href=
         *        "https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html#genref-aws-service-namespaces"
         *        >AWS Service Namespaces</a> in the <i>AWS General Reference</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceNamespaces(Collection<String> serviceNamespaces);

        /**
         * <p>
         * The service namespace for the AWS services whose policies you want to list.
         * </p>
         * <p>
         * To learn the service namespace for a service, go to <a href=
         * "https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_actions-resources-contextkeys.html"
         * >Actions, Resources, and Condition Keys for AWS Services</a> in the <i>IAM User Guide</i>. Choose the name of
         * the service to view details for that service. In the first paragraph, find the service prefix. For example,
         * <code>(service prefix: a4b)</code>. For more information about service namespaces, see <a href=
         * "https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html#genref-aws-service-namespaces"
         * >AWS Service Namespaces</a> in the <i>AWS General Reference</i>.
         * </p>
         * 
         * @param serviceNamespaces
         *        The service namespace for the AWS services whose policies you want to list.</p>
         *        <p>
         *        To learn the service namespace for a service, go to <a href=
         *        "https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_actions-resources-contextkeys.html"
         *        >Actions, Resources, and Condition Keys for AWS Services</a> in the <i>IAM User Guide</i>. Choose the
         *        name of the service to view details for that service. In the first paragraph, find the service prefix.
         *        For example, <code>(service prefix: a4b)</code>. For more information about service namespaces, see <a
         *        href=
         *        "https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html#genref-aws-service-namespaces"
         *        >AWS Service Namespaces</a> in the <i>AWS General Reference</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceNamespaces(String... serviceNamespaces);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends IamRequest.BuilderImpl implements Builder {
        private String marker;

        private String arn;

        private List<String> serviceNamespaces = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListPoliciesGrantingServiceAccessRequest model) {
            super(model);
            marker(model.marker);
            arn(model.arn);
            serviceNamespaces(model.serviceNamespaces);
        }

        public final String getMarker() {
            return marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        public final String getArn() {
            return arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final Collection<String> getServiceNamespaces() {
            return serviceNamespaces;
        }

        @Override
        public final Builder serviceNamespaces(Collection<String> serviceNamespaces) {
            this.serviceNamespaces = _serviceNamespaceListTypeCopier.copy(serviceNamespaces);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder serviceNamespaces(String... serviceNamespaces) {
            serviceNamespaces(Arrays.asList(serviceNamespaces));
            return this;
        }

        public final void setServiceNamespaces(Collection<String> serviceNamespaces) {
            this.serviceNamespaces = _serviceNamespaceListTypeCopier.copy(serviceNamespaces);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListPoliciesGrantingServiceAccessRequest build() {
            return new ListPoliciesGrantingServiceAccessRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
