/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iam.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetServiceLastAccessedDetailsResponse extends IamResponse implements
        ToCopyableBuilder<GetServiceLastAccessedDetailsResponse.Builder, GetServiceLastAccessedDetailsResponse> {
    private static final SdkField<String> JOB_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetServiceLastAccessedDetailsResponse::jobStatusAsString)).setter(setter(Builder::jobStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobStatus").build()).build();

    private static final SdkField<Instant> JOB_CREATION_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(GetServiceLastAccessedDetailsResponse::jobCreationDate)).setter(setter(Builder::jobCreationDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobCreationDate").build()).build();

    private static final SdkField<List<ServiceLastAccessed>> SERVICES_LAST_ACCESSED_FIELD = SdkField
            .<List<ServiceLastAccessed>> builder(MarshallingType.LIST)
            .getter(getter(GetServiceLastAccessedDetailsResponse::servicesLastAccessed))
            .setter(setter(Builder::servicesLastAccessed))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServicesLastAccessed").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ServiceLastAccessed> builder(MarshallingType.SDK_POJO)
                                            .constructor(ServiceLastAccessed::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Instant> JOB_COMPLETION_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(GetServiceLastAccessedDetailsResponse::jobCompletionDate)).setter(setter(Builder::jobCompletionDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobCompletionDate").build()).build();

    private static final SdkField<Boolean> IS_TRUNCATED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(GetServiceLastAccessedDetailsResponse::isTruncated)).setter(setter(Builder::isTruncated))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsTruncated").build()).build();

    private static final SdkField<String> MARKER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetServiceLastAccessedDetailsResponse::marker)).setter(setter(Builder::marker))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()).build();

    private static final SdkField<ErrorDetails> ERROR_FIELD = SdkField.<ErrorDetails> builder(MarshallingType.SDK_POJO)
            .getter(getter(GetServiceLastAccessedDetailsResponse::error)).setter(setter(Builder::error))
            .constructor(ErrorDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Error").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_STATUS_FIELD,
            JOB_CREATION_DATE_FIELD, SERVICES_LAST_ACCESSED_FIELD, JOB_COMPLETION_DATE_FIELD, IS_TRUNCATED_FIELD, MARKER_FIELD,
            ERROR_FIELD));

    private final String jobStatus;

    private final Instant jobCreationDate;

    private final List<ServiceLastAccessed> servicesLastAccessed;

    private final Instant jobCompletionDate;

    private final Boolean isTruncated;

    private final String marker;

    private final ErrorDetails error;

    private GetServiceLastAccessedDetailsResponse(BuilderImpl builder) {
        super(builder);
        this.jobStatus = builder.jobStatus;
        this.jobCreationDate = builder.jobCreationDate;
        this.servicesLastAccessed = builder.servicesLastAccessed;
        this.jobCompletionDate = builder.jobCompletionDate;
        this.isTruncated = builder.isTruncated;
        this.marker = builder.marker;
        this.error = builder.error;
    }

    /**
     * <p>
     * The status of the job.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #jobStatus} will
     * return {@link JobStatusType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #jobStatusAsString}.
     * </p>
     * 
     * @return The status of the job.
     * @see JobStatusType
     */
    public JobStatusType jobStatus() {
        return JobStatusType.fromValue(jobStatus);
    }

    /**
     * <p>
     * The status of the job.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #jobStatus} will
     * return {@link JobStatusType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #jobStatusAsString}.
     * </p>
     * 
     * @return The status of the job.
     * @see JobStatusType
     */
    public String jobStatusAsString() {
        return jobStatus;
    }

    /**
     * <p>
     * The date and time, in <a href="http://www.iso.org/iso/iso8601">ISO 8601 date-time format</a>, when the report job
     * was created.
     * </p>
     * 
     * @return The date and time, in <a href="http://www.iso.org/iso/iso8601">ISO 8601 date-time format</a>, when the
     *         report job was created.
     */
    public Instant jobCreationDate() {
        return jobCreationDate;
    }

    /**
     * Returns true if the ServicesLastAccessed property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasServicesLastAccessed() {
        return servicesLastAccessed != null && !(servicesLastAccessed instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A <code>ServiceLastAccessed</code> object that contains details about the most recent attempt to access the
     * service.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasServicesLastAccessed()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A <code>ServiceLastAccessed</code> object that contains details about the most recent attempt to access
     *         the service.
     */
    public List<ServiceLastAccessed> servicesLastAccessed() {
        return servicesLastAccessed;
    }

    /**
     * <p>
     * The date and time, in <a href="http://www.iso.org/iso/iso8601">ISO 8601 date-time format</a>, when the generated
     * report job was completed or failed.
     * </p>
     * <p>
     * This field is null if the job is still in progress, as indicated by a job status value of
     * <code>IN_PROGRESS</code>.
     * </p>
     * 
     * @return The date and time, in <a href="http://www.iso.org/iso/iso8601">ISO 8601 date-time format</a>, when the
     *         generated report job was completed or failed.</p>
     *         <p>
     *         This field is null if the job is still in progress, as indicated by a job status value of
     *         <code>IN_PROGRESS</code>.
     */
    public Instant jobCompletionDate() {
        return jobCompletionDate;
    }

    /**
     * <p/>
     * <p>
     * A flag that indicates whether there are more items to return. If your results were truncated, you can make a
     * subsequent pagination request using the <code>Marker</code> request parameter to retrieve more items. Note that
     * IAM might return fewer than the <code>MaxItems</code> number of results even when there are more results
     * available. We recommend that you check <code>IsTruncated</code> after every call to ensure that you receive all
     * your results.
     * </p>
     * 
     * @return <p>
     *         A flag that indicates whether there are more items to return. If your results were truncated, you can
     *         make a subsequent pagination request using the <code>Marker</code> request parameter to retrieve more
     *         items. Note that IAM might return fewer than the <code>MaxItems</code> number of results even when there
     *         are more results available. We recommend that you check <code>IsTruncated</code> after every call to
     *         ensure that you receive all your results.
     */
    public Boolean isTruncated() {
        return isTruncated;
    }

    /**
     * <p>
     * When <code>IsTruncated</code> is <code>true</code>, this element is present and contains the value to use for the
     * <code>Marker</code> parameter in a subsequent pagination request.
     * </p>
     * 
     * @return When <code>IsTruncated</code> is <code>true</code>, this element is present and contains the value to use
     *         for the <code>Marker</code> parameter in a subsequent pagination request.
     */
    public String marker() {
        return marker;
    }

    /**
     * <p>
     * An object that contains details about the reason the operation failed.
     * </p>
     * 
     * @return An object that contains details about the reason the operation failed.
     */
    public ErrorDetails error() {
        return error;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(jobStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(jobCreationDate());
        hashCode = 31 * hashCode + Objects.hashCode(servicesLastAccessed());
        hashCode = 31 * hashCode + Objects.hashCode(jobCompletionDate());
        hashCode = 31 * hashCode + Objects.hashCode(isTruncated());
        hashCode = 31 * hashCode + Objects.hashCode(marker());
        hashCode = 31 * hashCode + Objects.hashCode(error());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetServiceLastAccessedDetailsResponse)) {
            return false;
        }
        GetServiceLastAccessedDetailsResponse other = (GetServiceLastAccessedDetailsResponse) obj;
        return Objects.equals(jobStatusAsString(), other.jobStatusAsString())
                && Objects.equals(jobCreationDate(), other.jobCreationDate())
                && Objects.equals(servicesLastAccessed(), other.servicesLastAccessed())
                && Objects.equals(jobCompletionDate(), other.jobCompletionDate())
                && Objects.equals(isTruncated(), other.isTruncated()) && Objects.equals(marker(), other.marker())
                && Objects.equals(error(), other.error());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("GetServiceLastAccessedDetailsResponse").add("JobStatus", jobStatusAsString())
                .add("JobCreationDate", jobCreationDate()).add("ServicesLastAccessed", servicesLastAccessed())
                .add("JobCompletionDate", jobCompletionDate()).add("IsTruncated", isTruncated()).add("Marker", marker())
                .add("Error", error()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "JobStatus":
            return Optional.ofNullable(clazz.cast(jobStatusAsString()));
        case "JobCreationDate":
            return Optional.ofNullable(clazz.cast(jobCreationDate()));
        case "ServicesLastAccessed":
            return Optional.ofNullable(clazz.cast(servicesLastAccessed()));
        case "JobCompletionDate":
            return Optional.ofNullable(clazz.cast(jobCompletionDate()));
        case "IsTruncated":
            return Optional.ofNullable(clazz.cast(isTruncated()));
        case "Marker":
            return Optional.ofNullable(clazz.cast(marker()));
        case "Error":
            return Optional.ofNullable(clazz.cast(error()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetServiceLastAccessedDetailsResponse, T> g) {
        return obj -> g.apply((GetServiceLastAccessedDetailsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IamResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetServiceLastAccessedDetailsResponse> {
        /**
         * <p>
         * The status of the job.
         * </p>
         * 
         * @param jobStatus
         *        The status of the job.
         * @see JobStatusType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see JobStatusType
         */
        Builder jobStatus(String jobStatus);

        /**
         * <p>
         * The status of the job.
         * </p>
         * 
         * @param jobStatus
         *        The status of the job.
         * @see JobStatusType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see JobStatusType
         */
        Builder jobStatus(JobStatusType jobStatus);

        /**
         * <p>
         * The date and time, in <a href="http://www.iso.org/iso/iso8601">ISO 8601 date-time format</a>, when the report
         * job was created.
         * </p>
         * 
         * @param jobCreationDate
         *        The date and time, in <a href="http://www.iso.org/iso/iso8601">ISO 8601 date-time format</a>, when the
         *        report job was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobCreationDate(Instant jobCreationDate);

        /**
         * <p>
         * A <code>ServiceLastAccessed</code> object that contains details about the most recent attempt to access the
         * service.
         * </p>
         * 
         * @param servicesLastAccessed
         *        A <code>ServiceLastAccessed</code> object that contains details about the most recent attempt to
         *        access the service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder servicesLastAccessed(Collection<ServiceLastAccessed> servicesLastAccessed);

        /**
         * <p>
         * A <code>ServiceLastAccessed</code> object that contains details about the most recent attempt to access the
         * service.
         * </p>
         * 
         * @param servicesLastAccessed
         *        A <code>ServiceLastAccessed</code> object that contains details about the most recent attempt to
         *        access the service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder servicesLastAccessed(ServiceLastAccessed... servicesLastAccessed);

        /**
         * <p>
         * A <code>ServiceLastAccessed</code> object that contains details about the most recent attempt to access the
         * service.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ServiceLastAccessed>.Builder} avoiding the
         * need to create one manually via {@link List<ServiceLastAccessed>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ServiceLastAccessed>.Builder#build()} is called immediately
         * and its result is passed to {@link #servicesLastAccessed(List<ServiceLastAccessed>)}.
         * 
         * @param servicesLastAccessed
         *        a consumer that will call methods on {@link List<ServiceLastAccessed>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #servicesLastAccessed(List<ServiceLastAccessed>)
         */
        Builder servicesLastAccessed(Consumer<ServiceLastAccessed.Builder>... servicesLastAccessed);

        /**
         * <p>
         * The date and time, in <a href="http://www.iso.org/iso/iso8601">ISO 8601 date-time format</a>, when the
         * generated report job was completed or failed.
         * </p>
         * <p>
         * This field is null if the job is still in progress, as indicated by a job status value of
         * <code>IN_PROGRESS</code>.
         * </p>
         * 
         * @param jobCompletionDate
         *        The date and time, in <a href="http://www.iso.org/iso/iso8601">ISO 8601 date-time format</a>, when the
         *        generated report job was completed or failed.</p>
         *        <p>
         *        This field is null if the job is still in progress, as indicated by a job status value of
         *        <code>IN_PROGRESS</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobCompletionDate(Instant jobCompletionDate);

        /**
         * <p/>
         * <p>
         * A flag that indicates whether there are more items to return. If your results were truncated, you can make a
         * subsequent pagination request using the <code>Marker</code> request parameter to retrieve more items. Note
         * that IAM might return fewer than the <code>MaxItems</code> number of results even when there are more results
         * available. We recommend that you check <code>IsTruncated</code> after every call to ensure that you receive
         * all your results.
         * </p>
         * 
         * @param isTruncated
         *        <p>
         *        A flag that indicates whether there are more items to return. If your results were truncated, you can
         *        make a subsequent pagination request using the <code>Marker</code> request parameter to retrieve more
         *        items. Note that IAM might return fewer than the <code>MaxItems</code> number of results even when
         *        there are more results available. We recommend that you check <code>IsTruncated</code> after every
         *        call to ensure that you receive all your results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isTruncated(Boolean isTruncated);

        /**
         * <p>
         * When <code>IsTruncated</code> is <code>true</code>, this element is present and contains the value to use for
         * the <code>Marker</code> parameter in a subsequent pagination request.
         * </p>
         * 
         * @param marker
         *        When <code>IsTruncated</code> is <code>true</code>, this element is present and contains the value to
         *        use for the <code>Marker</code> parameter in a subsequent pagination request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder marker(String marker);

        /**
         * <p>
         * An object that contains details about the reason the operation failed.
         * </p>
         * 
         * @param error
         *        An object that contains details about the reason the operation failed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder error(ErrorDetails error);

        /**
         * <p>
         * An object that contains details about the reason the operation failed.
         * </p>
         * This is a convenience that creates an instance of the {@link ErrorDetails.Builder} avoiding the need to
         * create one manually via {@link ErrorDetails#builder()}.
         *
         * When the {@link Consumer} completes, {@link ErrorDetails.Builder#build()} is called immediately and its
         * result is passed to {@link #error(ErrorDetails)}.
         * 
         * @param error
         *        a consumer that will call methods on {@link ErrorDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #error(ErrorDetails)
         */
        default Builder error(Consumer<ErrorDetails.Builder> error) {
            return error(ErrorDetails.builder().applyMutation(error).build());
        }
    }

    static final class BuilderImpl extends IamResponse.BuilderImpl implements Builder {
        private String jobStatus;

        private Instant jobCreationDate;

        private List<ServiceLastAccessed> servicesLastAccessed = DefaultSdkAutoConstructList.getInstance();

        private Instant jobCompletionDate;

        private Boolean isTruncated;

        private String marker;

        private ErrorDetails error;

        private BuilderImpl() {
        }

        private BuilderImpl(GetServiceLastAccessedDetailsResponse model) {
            super(model);
            jobStatus(model.jobStatus);
            jobCreationDate(model.jobCreationDate);
            servicesLastAccessed(model.servicesLastAccessed);
            jobCompletionDate(model.jobCompletionDate);
            isTruncated(model.isTruncated);
            marker(model.marker);
            error(model.error);
        }

        public final String getJobStatusAsString() {
            return jobStatus;
        }

        @Override
        public final Builder jobStatus(String jobStatus) {
            this.jobStatus = jobStatus;
            return this;
        }

        @Override
        public final Builder jobStatus(JobStatusType jobStatus) {
            this.jobStatus(jobStatus == null ? null : jobStatus.toString());
            return this;
        }

        public final void setJobStatus(String jobStatus) {
            this.jobStatus = jobStatus;
        }

        public final Instant getJobCreationDate() {
            return jobCreationDate;
        }

        @Override
        public final Builder jobCreationDate(Instant jobCreationDate) {
            this.jobCreationDate = jobCreationDate;
            return this;
        }

        public final void setJobCreationDate(Instant jobCreationDate) {
            this.jobCreationDate = jobCreationDate;
        }

        public final Collection<ServiceLastAccessed.Builder> getServicesLastAccessed() {
            return servicesLastAccessed != null ? servicesLastAccessed.stream().map(ServiceLastAccessed::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder servicesLastAccessed(Collection<ServiceLastAccessed> servicesLastAccessed) {
            this.servicesLastAccessed = ServicesLastAccessedCopier.copy(servicesLastAccessed);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder servicesLastAccessed(ServiceLastAccessed... servicesLastAccessed) {
            servicesLastAccessed(Arrays.asList(servicesLastAccessed));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder servicesLastAccessed(Consumer<ServiceLastAccessed.Builder>... servicesLastAccessed) {
            servicesLastAccessed(Stream.of(servicesLastAccessed).map(c -> ServiceLastAccessed.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setServicesLastAccessed(Collection<ServiceLastAccessed.BuilderImpl> servicesLastAccessed) {
            this.servicesLastAccessed = ServicesLastAccessedCopier.copyFromBuilder(servicesLastAccessed);
        }

        public final Instant getJobCompletionDate() {
            return jobCompletionDate;
        }

        @Override
        public final Builder jobCompletionDate(Instant jobCompletionDate) {
            this.jobCompletionDate = jobCompletionDate;
            return this;
        }

        public final void setJobCompletionDate(Instant jobCompletionDate) {
            this.jobCompletionDate = jobCompletionDate;
        }

        public final Boolean getIsTruncated() {
            return isTruncated;
        }

        @Override
        public final Builder isTruncated(Boolean isTruncated) {
            this.isTruncated = isTruncated;
            return this;
        }

        public final void setIsTruncated(Boolean isTruncated) {
            this.isTruncated = isTruncated;
        }

        public final String getMarker() {
            return marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        public final ErrorDetails.Builder getError() {
            return error != null ? error.toBuilder() : null;
        }

        @Override
        public final Builder error(ErrorDetails error) {
            this.error = error;
            return this;
        }

        public final void setError(ErrorDetails.BuilderImpl error) {
            this.error = error != null ? error.build() : null;
        }

        @Override
        public GetServiceLastAccessedDetailsResponse build() {
            return new GetServiceLastAccessedDetailsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
