/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iam.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetServiceLastAccessedDetailsRequest extends IamRequest implements
        ToCopyableBuilder<GetServiceLastAccessedDetailsRequest.Builder, GetServiceLastAccessedDetailsRequest> {
    private static final SdkField<String> JOB_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetServiceLastAccessedDetailsRequest::jobId)).setter(setter(Builder::jobId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobId").build()).build();

    private static final SdkField<Integer> MAX_ITEMS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(GetServiceLastAccessedDetailsRequest::maxItems)).setter(setter(Builder::maxItems))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxItems").build()).build();

    private static final SdkField<String> MARKER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetServiceLastAccessedDetailsRequest::marker)).setter(setter(Builder::marker))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_ID_FIELD, MAX_ITEMS_FIELD,
            MARKER_FIELD));

    private final String jobId;

    private final Integer maxItems;

    private final String marker;

    private GetServiceLastAccessedDetailsRequest(BuilderImpl builder) {
        super(builder);
        this.jobId = builder.jobId;
        this.maxItems = builder.maxItems;
        this.marker = builder.marker;
    }

    /**
     * <p>
     * The ID of the request generated by the <a>GenerateServiceLastAccessedDetails</a> operation.
     * </p>
     * 
     * @return The ID of the request generated by the <a>GenerateServiceLastAccessedDetails</a> operation.
     */
    public String jobId() {
        return jobId;
    }

    /**
     * <p>
     * Use this only when paginating results to indicate the maximum number of items you want in the response. If
     * additional items exist beyond the maximum you specify, the <code>IsTruncated</code> response element is
     * <code>true</code>.
     * </p>
     * <p>
     * If you do not include this parameter, the number of items defaults to 100. Note that IAM might return fewer
     * results, even when there are more results available. In that case, the <code>IsTruncated</code> response element
     * returns <code>true</code>, and <code>Marker</code> contains a value to include in the subsequent call that tells
     * the service where to continue from.
     * </p>
     * 
     * @return Use this only when paginating results to indicate the maximum number of items you want in the response.
     *         If additional items exist beyond the maximum you specify, the <code>IsTruncated</code> response element
     *         is <code>true</code>.</p>
     *         <p>
     *         If you do not include this parameter, the number of items defaults to 100. Note that IAM might return
     *         fewer results, even when there are more results available. In that case, the <code>IsTruncated</code>
     *         response element returns <code>true</code>, and <code>Marker</code> contains a value to include in the
     *         subsequent call that tells the service where to continue from.
     */
    public Integer maxItems() {
        return maxItems;
    }

    /**
     * <p>
     * Use this parameter only when paginating results and only after you receive a response indicating that the results
     * are truncated. Set it to the value of the <code>Marker</code> element in the response that you received to
     * indicate where the next call should start.
     * </p>
     * 
     * @return Use this parameter only when paginating results and only after you receive a response indicating that the
     *         results are truncated. Set it to the value of the <code>Marker</code> element in the response that you
     *         received to indicate where the next call should start.
     */
    public String marker() {
        return marker;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(jobId());
        hashCode = 31 * hashCode + Objects.hashCode(maxItems());
        hashCode = 31 * hashCode + Objects.hashCode(marker());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetServiceLastAccessedDetailsRequest)) {
            return false;
        }
        GetServiceLastAccessedDetailsRequest other = (GetServiceLastAccessedDetailsRequest) obj;
        return Objects.equals(jobId(), other.jobId()) && Objects.equals(maxItems(), other.maxItems())
                && Objects.equals(marker(), other.marker());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("GetServiceLastAccessedDetailsRequest").add("JobId", jobId()).add("MaxItems", maxItems())
                .add("Marker", marker()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "JobId":
            return Optional.ofNullable(clazz.cast(jobId()));
        case "MaxItems":
            return Optional.ofNullable(clazz.cast(maxItems()));
        case "Marker":
            return Optional.ofNullable(clazz.cast(marker()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetServiceLastAccessedDetailsRequest, T> g) {
        return obj -> g.apply((GetServiceLastAccessedDetailsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IamRequest.Builder, SdkPojo, CopyableBuilder<Builder, GetServiceLastAccessedDetailsRequest> {
        /**
         * <p>
         * The ID of the request generated by the <a>GenerateServiceLastAccessedDetails</a> operation.
         * </p>
         * 
         * @param jobId
         *        The ID of the request generated by the <a>GenerateServiceLastAccessedDetails</a> operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobId(String jobId);

        /**
         * <p>
         * Use this only when paginating results to indicate the maximum number of items you want in the response. If
         * additional items exist beyond the maximum you specify, the <code>IsTruncated</code> response element is
         * <code>true</code>.
         * </p>
         * <p>
         * If you do not include this parameter, the number of items defaults to 100. Note that IAM might return fewer
         * results, even when there are more results available. In that case, the <code>IsTruncated</code> response
         * element returns <code>true</code>, and <code>Marker</code> contains a value to include in the subsequent call
         * that tells the service where to continue from.
         * </p>
         * 
         * @param maxItems
         *        Use this only when paginating results to indicate the maximum number of items you want in the
         *        response. If additional items exist beyond the maximum you specify, the <code>IsTruncated</code>
         *        response element is <code>true</code>.</p>
         *        <p>
         *        If you do not include this parameter, the number of items defaults to 100. Note that IAM might return
         *        fewer results, even when there are more results available. In that case, the <code>IsTruncated</code>
         *        response element returns <code>true</code>, and <code>Marker</code> contains a value to include in the
         *        subsequent call that tells the service where to continue from.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxItems(Integer maxItems);

        /**
         * <p>
         * Use this parameter only when paginating results and only after you receive a response indicating that the
         * results are truncated. Set it to the value of the <code>Marker</code> element in the response that you
         * received to indicate where the next call should start.
         * </p>
         * 
         * @param marker
         *        Use this parameter only when paginating results and only after you receive a response indicating that
         *        the results are truncated. Set it to the value of the <code>Marker</code> element in the response that
         *        you received to indicate where the next call should start.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder marker(String marker);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends IamRequest.BuilderImpl implements Builder {
        private String jobId;

        private Integer maxItems;

        private String marker;

        private BuilderImpl() {
        }

        private BuilderImpl(GetServiceLastAccessedDetailsRequest model) {
            super(model);
            jobId(model.jobId);
            maxItems(model.maxItems);
            marker(model.marker);
        }

        public final String getJobId() {
            return jobId;
        }

        @Override
        public final Builder jobId(String jobId) {
            this.jobId = jobId;
            return this;
        }

        public final void setJobId(String jobId) {
            this.jobId = jobId;
        }

        public final Integer getMaxItems() {
            return maxItems;
        }

        @Override
        public final Builder maxItems(Integer maxItems) {
            this.maxItems = maxItems;
            return this;
        }

        public final void setMaxItems(Integer maxItems) {
            this.maxItems = maxItems;
        }

        public final String getMarker() {
            return marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetServiceLastAccessedDetailsRequest build() {
            return new GetServiceLastAccessedDetailsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
