/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iam.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the response to a successful <a>GetAccountPasswordPolicy</a> request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetAccountPasswordPolicyResponse extends IamResponse implements
        ToCopyableBuilder<GetAccountPasswordPolicyResponse.Builder, GetAccountPasswordPolicyResponse> {
    private static final SdkField<PasswordPolicy> PASSWORD_POLICY_FIELD = SdkField
            .<PasswordPolicy> builder(MarshallingType.SDK_POJO).getter(getter(GetAccountPasswordPolicyResponse::passwordPolicy))
            .setter(setter(Builder::passwordPolicy)).constructor(PasswordPolicy::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PasswordPolicy").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PASSWORD_POLICY_FIELD));

    private final PasswordPolicy passwordPolicy;

    private GetAccountPasswordPolicyResponse(BuilderImpl builder) {
        super(builder);
        this.passwordPolicy = builder.passwordPolicy;
    }

    /**
     * <p>
     * A structure that contains details about the account's password policy.
     * </p>
     * 
     * @return A structure that contains details about the account's password policy.
     */
    public PasswordPolicy passwordPolicy() {
        return passwordPolicy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(passwordPolicy());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetAccountPasswordPolicyResponse)) {
            return false;
        }
        GetAccountPasswordPolicyResponse other = (GetAccountPasswordPolicyResponse) obj;
        return Objects.equals(passwordPolicy(), other.passwordPolicy());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("GetAccountPasswordPolicyResponse").add("PasswordPolicy", passwordPolicy()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PasswordPolicy":
            return Optional.ofNullable(clazz.cast(passwordPolicy()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetAccountPasswordPolicyResponse, T> g) {
        return obj -> g.apply((GetAccountPasswordPolicyResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IamResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetAccountPasswordPolicyResponse> {
        /**
         * <p>
         * A structure that contains details about the account's password policy.
         * </p>
         * 
         * @param passwordPolicy
         *        A structure that contains details about the account's password policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder passwordPolicy(PasswordPolicy passwordPolicy);

        /**
         * <p>
         * A structure that contains details about the account's password policy.
         * </p>
         * This is a convenience that creates an instance of the {@link PasswordPolicy.Builder} avoiding the need to
         * create one manually via {@link PasswordPolicy#builder()}.
         *
         * When the {@link Consumer} completes, {@link PasswordPolicy.Builder#build()} is called immediately and its
         * result is passed to {@link #passwordPolicy(PasswordPolicy)}.
         * 
         * @param passwordPolicy
         *        a consumer that will call methods on {@link PasswordPolicy.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #passwordPolicy(PasswordPolicy)
         */
        default Builder passwordPolicy(Consumer<PasswordPolicy.Builder> passwordPolicy) {
            return passwordPolicy(PasswordPolicy.builder().applyMutation(passwordPolicy).build());
        }
    }

    static final class BuilderImpl extends IamResponse.BuilderImpl implements Builder {
        private PasswordPolicy passwordPolicy;

        private BuilderImpl() {
        }

        private BuilderImpl(GetAccountPasswordPolicyResponse model) {
            super(model);
            passwordPolicy(model.passwordPolicy);
        }

        public final PasswordPolicy.Builder getPasswordPolicy() {
            return passwordPolicy != null ? passwordPolicy.toBuilder() : null;
        }

        @Override
        public final Builder passwordPolicy(PasswordPolicy passwordPolicy) {
            this.passwordPolicy = passwordPolicy;
            return this;
        }

        public final void setPasswordPolicy(PasswordPolicy.BuilderImpl passwordPolicy) {
            this.passwordPolicy = passwordPolicy != null ? passwordPolicy.build() : null;
        }

        @Override
        public GetAccountPasswordPolicyResponse build() {
            return new GetAccountPasswordPolicyResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
