/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iam.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the response to a successful <a>GenerateCredentialReport</a> request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GenerateCredentialReportResponse extends IamResponse implements
        ToCopyableBuilder<GenerateCredentialReportResponse.Builder, GenerateCredentialReportResponse> {
    private static final SdkField<String> STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GenerateCredentialReportResponse::stateAsString)).setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GenerateCredentialReportResponse::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(STATE_FIELD, DESCRIPTION_FIELD));

    private final String state;

    private final String description;

    private GenerateCredentialReportResponse(BuilderImpl builder) {
        super(builder);
        this.state = builder.state;
        this.description = builder.description;
    }

    /**
     * <p>
     * Information about the state of the credential report.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link ReportStateType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return Information about the state of the credential report.
     * @see ReportStateType
     */
    public ReportStateType state() {
        return ReportStateType.fromValue(state);
    }

    /**
     * <p>
     * Information about the state of the credential report.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link ReportStateType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return Information about the state of the credential report.
     * @see ReportStateType
     */
    public String stateAsString() {
        return state;
    }

    /**
     * <p>
     * Information about the credential report.
     * </p>
     * 
     * @return Information about the credential report.
     */
    public String description() {
        return description;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GenerateCredentialReportResponse)) {
            return false;
        }
        GenerateCredentialReportResponse other = (GenerateCredentialReportResponse) obj;
        return Objects.equals(stateAsString(), other.stateAsString()) && Objects.equals(description(), other.description());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("GenerateCredentialReportResponse").add("State", stateAsString())
                .add("Description", description()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "State":
            return Optional.ofNullable(clazz.cast(stateAsString()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GenerateCredentialReportResponse, T> g) {
        return obj -> g.apply((GenerateCredentialReportResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IamResponse.Builder, SdkPojo, CopyableBuilder<Builder, GenerateCredentialReportResponse> {
        /**
         * <p>
         * Information about the state of the credential report.
         * </p>
         * 
         * @param state
         *        Information about the state of the credential report.
         * @see ReportStateType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReportStateType
         */
        Builder state(String state);

        /**
         * <p>
         * Information about the state of the credential report.
         * </p>
         * 
         * @param state
         *        Information about the state of the credential report.
         * @see ReportStateType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReportStateType
         */
        Builder state(ReportStateType state);

        /**
         * <p>
         * Information about the credential report.
         * </p>
         * 
         * @param description
         *        Information about the credential report.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);
    }

    static final class BuilderImpl extends IamResponse.BuilderImpl implements Builder {
        private String state;

        private String description;

        private BuilderImpl() {
        }

        private BuilderImpl(GenerateCredentialReportResponse model) {
            super(model);
            state(model.state);
            description(model.description);
        }

        public final String getStateAsString() {
            return state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(ReportStateType state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public GenerateCredentialReportResponse build() {
            return new GenerateCredentialReportResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
