/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iam.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about the last time an AWS access key was used since IAM began tracking this information on
 * April 22, 2015.
 * </p>
 * <p>
 * This data type is used as a response element in the <a>GetAccessKeyLastUsed</a> operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AccessKeyLastUsed implements SdkPojo, Serializable,
        ToCopyableBuilder<AccessKeyLastUsed.Builder, AccessKeyLastUsed> {
    private static final SdkField<Instant> LAST_USED_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(AccessKeyLastUsed::lastUsedDate)).setter(setter(Builder::lastUsedDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUsedDate").build()).build();

    private static final SdkField<String> SERVICE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AccessKeyLastUsed::serviceName)).setter(setter(Builder::serviceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceName").build()).build();

    private static final SdkField<String> REGION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AccessKeyLastUsed::region)).setter(setter(Builder::region))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Region").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LAST_USED_DATE_FIELD,
            SERVICE_NAME_FIELD, REGION_FIELD));

    private static final long serialVersionUID = 1L;

    private final Instant lastUsedDate;

    private final String serviceName;

    private final String region;

    private AccessKeyLastUsed(BuilderImpl builder) {
        this.lastUsedDate = builder.lastUsedDate;
        this.serviceName = builder.serviceName;
        this.region = builder.region;
    }

    /**
     * <p>
     * The date and time, in <a href="http://www.iso.org/iso/iso8601">ISO 8601 date-time format</a>, when the access key
     * was most recently used. This field is null in the following situations:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The user does not have an access key.
     * </p>
     * </li>
     * <li>
     * <p>
     * An access key exists but has not been used since IAM began tracking this information.
     * </p>
     * </li>
     * <li>
     * <p>
     * There is no sign-in data associated with the user.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The date and time, in <a href="http://www.iso.org/iso/iso8601">ISO 8601 date-time format</a>, when the
     *         access key was most recently used. This field is null in the following situations:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         The user does not have an access key.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         An access key exists but has not been used since IAM began tracking this information.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         There is no sign-in data associated with the user.
     *         </p>
     *         </li>
     */
    public Instant lastUsedDate() {
        return lastUsedDate;
    }

    /**
     * <p>
     * The name of the AWS service with which this access key was most recently used. The value of this field is "N/A"
     * in the following situations:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The user does not have an access key.
     * </p>
     * </li>
     * <li>
     * <p>
     * An access key exists but has not been used since IAM started tracking this information.
     * </p>
     * </li>
     * <li>
     * <p>
     * There is no sign-in data associated with the user.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The name of the AWS service with which this access key was most recently used. The value of this field is
     *         "N/A" in the following situations:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         The user does not have an access key.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         An access key exists but has not been used since IAM started tracking this information.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         There is no sign-in data associated with the user.
     *         </p>
     *         </li>
     */
    public String serviceName() {
        return serviceName;
    }

    /**
     * <p>
     * The AWS Region where this access key was most recently used. The value for this field is "N/A" in the following
     * situations:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The user does not have an access key.
     * </p>
     * </li>
     * <li>
     * <p>
     * An access key exists but has not been used since IAM began tracking this information.
     * </p>
     * </li>
     * <li>
     * <p>
     * There is no sign-in data associated with the user.
     * </p>
     * </li>
     * </ul>
     * <p>
     * For more information about AWS Regions, see <a
     * href="https://docs.aws.amazon.com/general/latest/gr/rande.html">Regions and Endpoints</a> in the Amazon Web
     * Services General Reference.
     * </p>
     * 
     * @return The AWS Region where this access key was most recently used. The value for this field is "N/A" in the
     *         following situations:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         The user does not have an access key.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         An access key exists but has not been used since IAM began tracking this information.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         There is no sign-in data associated with the user.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For more information about AWS Regions, see <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/rande.html">Regions and Endpoints</a> in the Amazon
     *         Web Services General Reference.
     */
    public String region() {
        return region;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(lastUsedDate());
        hashCode = 31 * hashCode + Objects.hashCode(serviceName());
        hashCode = 31 * hashCode + Objects.hashCode(region());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AccessKeyLastUsed)) {
            return false;
        }
        AccessKeyLastUsed other = (AccessKeyLastUsed) obj;
        return Objects.equals(lastUsedDate(), other.lastUsedDate()) && Objects.equals(serviceName(), other.serviceName())
                && Objects.equals(region(), other.region());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("AccessKeyLastUsed").add("LastUsedDate", lastUsedDate()).add("ServiceName", serviceName())
                .add("Region", region()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "LastUsedDate":
            return Optional.ofNullable(clazz.cast(lastUsedDate()));
        case "ServiceName":
            return Optional.ofNullable(clazz.cast(serviceName()));
        case "Region":
            return Optional.ofNullable(clazz.cast(region()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AccessKeyLastUsed, T> g) {
        return obj -> g.apply((AccessKeyLastUsed) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AccessKeyLastUsed> {
        /**
         * <p>
         * The date and time, in <a href="http://www.iso.org/iso/iso8601">ISO 8601 date-time format</a>, when the access
         * key was most recently used. This field is null in the following situations:
         * </p>
         * <ul>
         * <li>
         * <p>
         * The user does not have an access key.
         * </p>
         * </li>
         * <li>
         * <p>
         * An access key exists but has not been used since IAM began tracking this information.
         * </p>
         * </li>
         * <li>
         * <p>
         * There is no sign-in data associated with the user.
         * </p>
         * </li>
         * </ul>
         * 
         * @param lastUsedDate
         *        The date and time, in <a href="http://www.iso.org/iso/iso8601">ISO 8601 date-time format</a>, when the
         *        access key was most recently used. This field is null in the following situations:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        The user does not have an access key.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        An access key exists but has not been used since IAM began tracking this information.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        There is no sign-in data associated with the user.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUsedDate(Instant lastUsedDate);

        /**
         * <p>
         * The name of the AWS service with which this access key was most recently used. The value of this field is
         * "N/A" in the following situations:
         * </p>
         * <ul>
         * <li>
         * <p>
         * The user does not have an access key.
         * </p>
         * </li>
         * <li>
         * <p>
         * An access key exists but has not been used since IAM started tracking this information.
         * </p>
         * </li>
         * <li>
         * <p>
         * There is no sign-in data associated with the user.
         * </p>
         * </li>
         * </ul>
         * 
         * @param serviceName
         *        The name of the AWS service with which this access key was most recently used. The value of this field
         *        is "N/A" in the following situations:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        The user does not have an access key.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        An access key exists but has not been used since IAM started tracking this information.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        There is no sign-in data associated with the user.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceName(String serviceName);

        /**
         * <p>
         * The AWS Region where this access key was most recently used. The value for this field is "N/A" in the
         * following situations:
         * </p>
         * <ul>
         * <li>
         * <p>
         * The user does not have an access key.
         * </p>
         * </li>
         * <li>
         * <p>
         * An access key exists but has not been used since IAM began tracking this information.
         * </p>
         * </li>
         * <li>
         * <p>
         * There is no sign-in data associated with the user.
         * </p>
         * </li>
         * </ul>
         * <p>
         * For more information about AWS Regions, see <a
         * href="https://docs.aws.amazon.com/general/latest/gr/rande.html">Regions and Endpoints</a> in the Amazon Web
         * Services General Reference.
         * </p>
         * 
         * @param region
         *        The AWS Region where this access key was most recently used. The value for this field is "N/A" in the
         *        following situations:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        The user does not have an access key.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        An access key exists but has not been used since IAM began tracking this information.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        There is no sign-in data associated with the user.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        For more information about AWS Regions, see <a
         *        href="https://docs.aws.amazon.com/general/latest/gr/rande.html">Regions and Endpoints</a> in the
         *        Amazon Web Services General Reference.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder region(String region);
    }

    static final class BuilderImpl implements Builder {
        private Instant lastUsedDate;

        private String serviceName;

        private String region;

        private BuilderImpl() {
        }

        private BuilderImpl(AccessKeyLastUsed model) {
            lastUsedDate(model.lastUsedDate);
            serviceName(model.serviceName);
            region(model.region);
        }

        public final Instant getLastUsedDate() {
            return lastUsedDate;
        }

        @Override
        public final Builder lastUsedDate(Instant lastUsedDate) {
            this.lastUsedDate = lastUsedDate;
            return this;
        }

        public final void setLastUsedDate(Instant lastUsedDate) {
            this.lastUsedDate = lastUsedDate;
        }

        public final String getServiceName() {
            return serviceName;
        }

        @Override
        public final Builder serviceName(String serviceName) {
            this.serviceName = serviceName;
            return this;
        }

        public final void setServiceName(String serviceName) {
            this.serviceName = serviceName;
        }

        public final String getRegion() {
            return region;
        }

        @Override
        public final Builder region(String region) {
            this.region = region;
            return this;
        }

        public final void setRegion(String region) {
            this.region = region;
        }

        @Override
        public AccessKeyLastUsed build() {
            return new AccessKeyLastUsed(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
