/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.iam.model.ContextEntry;
import software.amazon.awssdk.services.iam.model.SimulateCustomPolicyRequest;

public class SimulateCustomPolicyRequestMarshaller
implements Marshaller<Request<SimulateCustomPolicyRequest>, SimulateCustomPolicyRequest> {
    /*
     * WARNING - void declaration
     */
    public Request<SimulateCustomPolicyRequest> marshall(SimulateCustomPolicyRequest simulateCustomPolicyRequest) {
        List<ContextEntry> list;
        List<String> resourceArnsList;
        List<String> actionNamesList;
        if (simulateCustomPolicyRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((Object)simulateCustomPolicyRequest, "IAMClient");
        request.addParameter("Action", "SimulateCustomPolicy");
        request.addParameter("Version", "2010-05-08");
        request.setHttpMethod(HttpMethodName.POST);
        List<String> policyInputListList = simulateCustomPolicyRequest.policyInputList();
        if (policyInputListList != null) {
            if (!policyInputListList.isEmpty()) {
                int policyInputListListIndex = 1;
                for (String string : policyInputListList) {
                    if (string != null) {
                        request.addParameter("PolicyInputList.member." + policyInputListListIndex, StringUtils.fromString((String)string));
                    }
                    ++policyInputListListIndex;
                }
            } else {
                request.addParameter("PolicyInputList", "");
            }
        }
        if ((actionNamesList = simulateCustomPolicyRequest.actionNames()) != null) {
            if (!actionNamesList.isEmpty()) {
                int actionNamesListIndex = 1;
                for (String string : actionNamesList) {
                    if (string != null) {
                        request.addParameter("ActionNames.member." + actionNamesListIndex, StringUtils.fromString((String)string));
                    }
                    ++actionNamesListIndex;
                }
            } else {
                request.addParameter("ActionNames", "");
            }
        }
        if ((resourceArnsList = simulateCustomPolicyRequest.resourceArns()) != null) {
            if (!resourceArnsList.isEmpty()) {
                boolean bl = true;
                for (String resourceArnsListValue : resourceArnsList) {
                    void var6_12;
                    if (resourceArnsListValue != null) {
                        request.addParameter("ResourceArns.member." + (int)var6_12, StringUtils.fromString((String)resourceArnsListValue));
                    }
                    ++var6_12;
                }
            } else {
                request.addParameter("ResourceArns", "");
            }
        }
        if (simulateCustomPolicyRequest.resourcePolicy() != null) {
            request.addParameter("ResourcePolicy", StringUtils.fromString((String)simulateCustomPolicyRequest.resourcePolicy()));
        }
        if (simulateCustomPolicyRequest.resourceOwner() != null) {
            request.addParameter("ResourceOwner", StringUtils.fromString((String)simulateCustomPolicyRequest.resourceOwner()));
        }
        if (simulateCustomPolicyRequest.callerArn() != null) {
            request.addParameter("CallerArn", StringUtils.fromString((String)simulateCustomPolicyRequest.callerArn()));
        }
        if ((list = simulateCustomPolicyRequest.contextEntries()) != null) {
            if (!list.isEmpty()) {
                boolean bl = true;
                for (ContextEntry contextEntriesListValue : list) {
                    List<String> contextKeyValuesList;
                    void var7_18;
                    if (contextEntriesListValue.contextKeyName() != null) {
                        request.addParameter("ContextEntries.member." + (int)var7_18 + ".ContextKeyName", StringUtils.fromString((String)contextEntriesListValue.contextKeyName()));
                    }
                    if ((contextKeyValuesList = contextEntriesListValue.contextKeyValues()) != null) {
                        if (!contextKeyValuesList.isEmpty()) {
                            int contextKeyValuesListIndex = 1;
                            for (String contextKeyValuesListValue : contextKeyValuesList) {
                                if (contextKeyValuesListValue != null) {
                                    request.addParameter("ContextEntries.member." + (int)var7_18 + ".ContextKeyValues.member." + contextKeyValuesListIndex, StringUtils.fromString((String)contextKeyValuesListValue));
                                }
                                ++contextKeyValuesListIndex;
                            }
                        } else {
                            request.addParameter("ContextEntries.member." + (int)var7_18 + ".ContextKeyValues", "");
                        }
                    }
                    if (contextEntriesListValue.contextKeyTypeString() != null) {
                        request.addParameter("ContextEntries.member." + (int)var7_18 + ".ContextKeyType", StringUtils.fromString((String)contextEntriesListValue.contextKeyTypeString()));
                    }
                    ++var7_18;
                }
            } else {
                request.addParameter("ContextEntries", "");
            }
        }
        if (simulateCustomPolicyRequest.resourceHandlingOption() != null) {
            request.addParameter("ResourceHandlingOption", StringUtils.fromString((String)simulateCustomPolicyRequest.resourceHandlingOption()));
        }
        if (simulateCustomPolicyRequest.maxItems() != null) {
            request.addParameter("MaxItems", StringUtils.fromInteger((Integer)simulateCustomPolicyRequest.maxItems()));
        }
        if (simulateCustomPolicyRequest.marker() != null) {
            request.addParameter("Marker", StringUtils.fromString((String)simulateCustomPolicyRequest.marker()));
        }
        return request;
    }
}

