/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.transform;

import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.iam.model.ListPoliciesRequest;

public class ListPoliciesRequestMarshaller
implements Marshaller<Request<ListPoliciesRequest>, ListPoliciesRequest> {
    public Request<ListPoliciesRequest> marshall(ListPoliciesRequest listPoliciesRequest) {
        if (listPoliciesRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((Object)listPoliciesRequest, "IAMClient");
        request.addParameter("Action", "ListPolicies");
        request.addParameter("Version", "2010-05-08");
        request.setHttpMethod(HttpMethodName.POST);
        if (listPoliciesRequest.scopeString() != null) {
            request.addParameter("Scope", StringUtils.fromString((String)listPoliciesRequest.scopeString()));
        }
        if (listPoliciesRequest.onlyAttached() != null) {
            request.addParameter("OnlyAttached", StringUtils.fromBoolean((Boolean)listPoliciesRequest.onlyAttached()));
        }
        if (listPoliciesRequest.pathPrefix() != null) {
            request.addParameter("PathPrefix", StringUtils.fromString((String)listPoliciesRequest.pathPrefix()));
        }
        if (listPoliciesRequest.marker() != null) {
            request.addParameter("Marker", StringUtils.fromString((String)listPoliciesRequest.marker()));
        }
        if (listPoliciesRequest.maxItems() != null) {
            request.addParameter("MaxItems", StringUtils.fromInteger((Integer)listPoliciesRequest.maxItems()));
        }
        return request;
    }
}

