/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.iam.model.GetContextKeysForCustomPolicyRequest;

public class GetContextKeysForCustomPolicyRequestMarshaller
implements Marshaller<Request<GetContextKeysForCustomPolicyRequest>, GetContextKeysForCustomPolicyRequest> {
    public Request<GetContextKeysForCustomPolicyRequest> marshall(GetContextKeysForCustomPolicyRequest getContextKeysForCustomPolicyRequest) {
        if (getContextKeysForCustomPolicyRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((Object)getContextKeysForCustomPolicyRequest, "IAMClient");
        request.addParameter("Action", "GetContextKeysForCustomPolicy");
        request.addParameter("Version", "2010-05-08");
        request.setHttpMethod(HttpMethodName.POST);
        List<String> policyInputListList = getContextKeysForCustomPolicyRequest.policyInputList();
        if (policyInputListList != null) {
            if (!policyInputListList.isEmpty()) {
                int policyInputListListIndex = 1;
                for (String policyInputListListValue : policyInputListList) {
                    if (policyInputListListValue != null) {
                        request.addParameter("PolicyInputList.member." + policyInputListListIndex, StringUtils.fromString((String)policyInputListListValue));
                    }
                    ++policyInputListListIndex;
                }
            } else {
                request.addParameter("PolicyInputList", "");
            }
        }
        return request;
    }
}

