/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.transform;

import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.iam.model.CreateServiceSpecificCredentialRequest;

public class CreateServiceSpecificCredentialRequestMarshaller
implements Marshaller<Request<CreateServiceSpecificCredentialRequest>, CreateServiceSpecificCredentialRequest> {
    public Request<CreateServiceSpecificCredentialRequest> marshall(CreateServiceSpecificCredentialRequest createServiceSpecificCredentialRequest) {
        if (createServiceSpecificCredentialRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((Object)createServiceSpecificCredentialRequest, "IAMClient");
        request.addParameter("Action", "CreateServiceSpecificCredential");
        request.addParameter("Version", "2010-05-08");
        request.setHttpMethod(HttpMethodName.POST);
        if (createServiceSpecificCredentialRequest.userName() != null) {
            request.addParameter("UserName", StringUtils.fromString((String)createServiceSpecificCredentialRequest.userName()));
        }
        if (createServiceSpecificCredentialRequest.serviceName() != null) {
            request.addParameter("ServiceName", StringUtils.fromString((String)createServiceSpecificCredentialRequest.serviceName()));
        }
        return request;
    }
}

