/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.EmptySubscription;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.pagination.async.SdkPublisher;
import software.amazon.awssdk.services.iam.IAMAsyncClient;
import software.amazon.awssdk.services.iam.model.EvaluationResult;
import software.amazon.awssdk.services.iam.model.SimulatePrincipalPolicyRequest;
import software.amazon.awssdk.services.iam.model.SimulatePrincipalPolicyResponse;

public class SimulatePrincipalPolicyPublisher
implements SdkPublisher<SimulatePrincipalPolicyResponse> {
    private final IAMAsyncClient client;
    private final SimulatePrincipalPolicyRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public SimulatePrincipalPolicyPublisher(IAMAsyncClient client, SimulatePrincipalPolicyRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private SimulatePrincipalPolicyPublisher(IAMAsyncClient client, SimulatePrincipalPolicyRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new SimulatePrincipalPolicyResponseFetcher();
    }

    public void subscribe(Subscriber<? super SimulatePrincipalPolicyResponse> subscriber) {
        subscriber.onSubscribe((Subscription)new ResponsesSubscription(subscriber, this.nextPageFetcher));
    }

    public final SdkPublisher<EvaluationResult> evaluationResults() {
        Function<SimulatePrincipalPolicyResponse, Iterator> getIterator = response -> {
            if (response != null && response.evaluationResults() != null) {
                return response.evaluationResults().iterator();
            }
            return Collections.emptyIterator();
        };
        return new PaginatedItemsPublisher((AsyncPageFetcher)new SimulatePrincipalPolicyResponseFetcher(), getIterator, this.isLastPage);
    }

    public final SimulatePrincipalPolicyPublisher resume(SimulatePrincipalPolicyResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new SimulatePrincipalPolicyPublisher(this.client, (SimulatePrincipalPolicyRequest)((Object)this.firstRequest.toBuilder().marker(lastSuccessfulPage.marker()).build()));
        }
        return new SimulatePrincipalPolicyPublisher(this.client, this.firstRequest, true){

            @Override
            public void subscribe(Subscriber<? super SimulatePrincipalPolicyResponse> subscriber) {
                subscriber.onSubscribe((Subscription)new EmptySubscription(subscriber));
            }
        };
    }

    private class SimulatePrincipalPolicyResponseFetcher
    implements AsyncPageFetcher<SimulatePrincipalPolicyResponse> {
        private SimulatePrincipalPolicyResponseFetcher() {
        }

        public boolean hasNextPage(SimulatePrincipalPolicyResponse previousPage) {
            return previousPage.isTruncated();
        }

        public CompletableFuture<SimulatePrincipalPolicyResponse> nextPage(SimulatePrincipalPolicyResponse previousPage) {
            if (previousPage == null) {
                return SimulatePrincipalPolicyPublisher.this.client.simulatePrincipalPolicy(SimulatePrincipalPolicyPublisher.this.firstRequest);
            }
            return SimulatePrincipalPolicyPublisher.this.client.simulatePrincipalPolicy((SimulatePrincipalPolicyRequest)((Object)SimulatePrincipalPolicyPublisher.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

