/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.core.pagination.SyncPageFetcher;
import software.amazon.awssdk.services.iam.IAMClient;
import software.amazon.awssdk.services.iam.model.EvaluationResult;
import software.amazon.awssdk.services.iam.model.SimulatePrincipalPolicyRequest;
import software.amazon.awssdk.services.iam.model.SimulatePrincipalPolicyResponse;

public class SimulatePrincipalPolicyIterable
implements SdkIterable<SimulatePrincipalPolicyResponse> {
    private final IAMClient client;
    private final SimulatePrincipalPolicyRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public SimulatePrincipalPolicyIterable(IAMClient client, SimulatePrincipalPolicyRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new SimulatePrincipalPolicyResponseFetcher();
    }

    public Iterator<SimulatePrincipalPolicyResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    public final SdkIterable<EvaluationResult> evaluationResults() {
        Function<SimulatePrincipalPolicyResponse, Iterator> getIterator = response -> {
            if (response != null && response.evaluationResults() != null) {
                return response.evaluationResults().iterator();
            }
            return Collections.emptyIterator();
        };
        return new PaginatedItemsIterable((SdkIterable)this, getIterator);
    }

    public final SimulatePrincipalPolicyIterable resume(SimulatePrincipalPolicyResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new SimulatePrincipalPolicyIterable(this.client, (SimulatePrincipalPolicyRequest)((Object)this.firstRequest.toBuilder().marker(lastSuccessfulPage.marker()).build()));
        }
        return new SimulatePrincipalPolicyIterable(this.client, this.firstRequest){

            @Override
            public Iterator<SimulatePrincipalPolicyResponse> iterator() {
                return Collections.emptyIterator();
            }
        };
    }

    private class SimulatePrincipalPolicyResponseFetcher
    implements SyncPageFetcher<SimulatePrincipalPolicyResponse> {
        private SimulatePrincipalPolicyResponseFetcher() {
        }

        public boolean hasNextPage(SimulatePrincipalPolicyResponse previousPage) {
            return previousPage.isTruncated();
        }

        public SimulatePrincipalPolicyResponse nextPage(SimulatePrincipalPolicyResponse previousPage) {
            if (previousPage == null) {
                return SimulatePrincipalPolicyIterable.this.client.simulatePrincipalPolicy(SimulatePrincipalPolicyIterable.this.firstRequest);
            }
            return SimulatePrincipalPolicyIterable.this.client.simulatePrincipalPolicy((SimulatePrincipalPolicyRequest)((Object)SimulatePrincipalPolicyIterable.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

