/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.core.pagination.SyncPageFetcher;
import software.amazon.awssdk.services.iam.IAMClient;
import software.amazon.awssdk.services.iam.model.EvaluationResult;
import software.amazon.awssdk.services.iam.model.SimulateCustomPolicyRequest;
import software.amazon.awssdk.services.iam.model.SimulateCustomPolicyResponse;

public class SimulateCustomPolicyIterable
implements SdkIterable<SimulateCustomPolicyResponse> {
    private final IAMClient client;
    private final SimulateCustomPolicyRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public SimulateCustomPolicyIterable(IAMClient client, SimulateCustomPolicyRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new SimulateCustomPolicyResponseFetcher();
    }

    public Iterator<SimulateCustomPolicyResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    public final SdkIterable<EvaluationResult> evaluationResults() {
        Function<SimulateCustomPolicyResponse, Iterator> getIterator = response -> {
            if (response != null && response.evaluationResults() != null) {
                return response.evaluationResults().iterator();
            }
            return Collections.emptyIterator();
        };
        return new PaginatedItemsIterable((SdkIterable)this, getIterator);
    }

    public final SimulateCustomPolicyIterable resume(SimulateCustomPolicyResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new SimulateCustomPolicyIterable(this.client, (SimulateCustomPolicyRequest)((Object)this.firstRequest.toBuilder().marker(lastSuccessfulPage.marker()).build()));
        }
        return new SimulateCustomPolicyIterable(this.client, this.firstRequest){

            @Override
            public Iterator<SimulateCustomPolicyResponse> iterator() {
                return Collections.emptyIterator();
            }
        };
    }

    private class SimulateCustomPolicyResponseFetcher
    implements SyncPageFetcher<SimulateCustomPolicyResponse> {
        private SimulateCustomPolicyResponseFetcher() {
        }

        public boolean hasNextPage(SimulateCustomPolicyResponse previousPage) {
            return previousPage.isTruncated();
        }

        public SimulateCustomPolicyResponse nextPage(SimulateCustomPolicyResponse previousPage) {
            if (previousPage == null) {
                return SimulateCustomPolicyIterable.this.client.simulateCustomPolicy(SimulateCustomPolicyIterable.this.firstRequest);
            }
            return SimulateCustomPolicyIterable.this.client.simulateCustomPolicy((SimulateCustomPolicyRequest)((Object)SimulateCustomPolicyIterable.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

