/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.core.pagination.SyncPageFetcher;
import software.amazon.awssdk.services.iam.IAMClient;
import software.amazon.awssdk.services.iam.model.ListServerCertificatesRequest;
import software.amazon.awssdk.services.iam.model.ListServerCertificatesResponse;
import software.amazon.awssdk.services.iam.model.ServerCertificateMetadata;

public class ListServerCertificatesIterable
implements SdkIterable<ListServerCertificatesResponse> {
    private final IAMClient client;
    private final ListServerCertificatesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListServerCertificatesIterable(IAMClient client, ListServerCertificatesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListServerCertificatesResponseFetcher();
    }

    public Iterator<ListServerCertificatesResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    public final SdkIterable<ServerCertificateMetadata> serverCertificateMetadataList() {
        Function<ListServerCertificatesResponse, Iterator> getIterator = response -> {
            if (response != null && response.serverCertificateMetadataList() != null) {
                return response.serverCertificateMetadataList().iterator();
            }
            return Collections.emptyIterator();
        };
        return new PaginatedItemsIterable((SdkIterable)this, getIterator);
    }

    public final ListServerCertificatesIterable resume(ListServerCertificatesResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new ListServerCertificatesIterable(this.client, (ListServerCertificatesRequest)((Object)this.firstRequest.toBuilder().marker(lastSuccessfulPage.marker()).build()));
        }
        return new ListServerCertificatesIterable(this.client, this.firstRequest){

            @Override
            public Iterator<ListServerCertificatesResponse> iterator() {
                return Collections.emptyIterator();
            }
        };
    }

    private class ListServerCertificatesResponseFetcher
    implements SyncPageFetcher<ListServerCertificatesResponse> {
        private ListServerCertificatesResponseFetcher() {
        }

        public boolean hasNextPage(ListServerCertificatesResponse previousPage) {
            return previousPage.isTruncated();
        }

        public ListServerCertificatesResponse nextPage(ListServerCertificatesResponse previousPage) {
            if (previousPage == null) {
                return ListServerCertificatesIterable.this.client.listServerCertificates(ListServerCertificatesIterable.this.firstRequest);
            }
            return ListServerCertificatesIterable.this.client.listServerCertificates((ListServerCertificatesRequest)((Object)ListServerCertificatesIterable.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

