/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.core.pagination.SyncPageFetcher;
import software.amazon.awssdk.services.iam.IAMClient;
import software.amazon.awssdk.services.iam.model.AttachedPolicy;
import software.amazon.awssdk.services.iam.model.ListAttachedGroupPoliciesRequest;
import software.amazon.awssdk.services.iam.model.ListAttachedGroupPoliciesResponse;

public class ListAttachedGroupPoliciesIterable
implements SdkIterable<ListAttachedGroupPoliciesResponse> {
    private final IAMClient client;
    private final ListAttachedGroupPoliciesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListAttachedGroupPoliciesIterable(IAMClient client, ListAttachedGroupPoliciesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListAttachedGroupPoliciesResponseFetcher();
    }

    public Iterator<ListAttachedGroupPoliciesResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    public final SdkIterable<AttachedPolicy> attachedPolicies() {
        Function<ListAttachedGroupPoliciesResponse, Iterator> getIterator = response -> {
            if (response != null && response.attachedPolicies() != null) {
                return response.attachedPolicies().iterator();
            }
            return Collections.emptyIterator();
        };
        return new PaginatedItemsIterable((SdkIterable)this, getIterator);
    }

    public final ListAttachedGroupPoliciesIterable resume(ListAttachedGroupPoliciesResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new ListAttachedGroupPoliciesIterable(this.client, (ListAttachedGroupPoliciesRequest)((Object)this.firstRequest.toBuilder().marker(lastSuccessfulPage.marker()).build()));
        }
        return new ListAttachedGroupPoliciesIterable(this.client, this.firstRequest){

            @Override
            public Iterator<ListAttachedGroupPoliciesResponse> iterator() {
                return Collections.emptyIterator();
            }
        };
    }

    private class ListAttachedGroupPoliciesResponseFetcher
    implements SyncPageFetcher<ListAttachedGroupPoliciesResponse> {
        private ListAttachedGroupPoliciesResponseFetcher() {
        }

        public boolean hasNextPage(ListAttachedGroupPoliciesResponse previousPage) {
            return previousPage.isTruncated();
        }

        public ListAttachedGroupPoliciesResponse nextPage(ListAttachedGroupPoliciesResponse previousPage) {
            if (previousPage == null) {
                return ListAttachedGroupPoliciesIterable.this.client.listAttachedGroupPolicies(ListAttachedGroupPoliciesIterable.this.firstRequest);
            }
            return ListAttachedGroupPoliciesIterable.this.client.listAttachedGroupPolicies((ListAttachedGroupPoliciesRequest)((Object)ListAttachedGroupPoliciesIterable.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

