/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.model;

import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.services.iam.model.StatusType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class SigningCertificate
implements ToCopyableBuilder<Builder, SigningCertificate> {
    private final String userName;
    private final String certificateId;
    private final String certificateBody;
    private final String status;
    private final Instant uploadDate;

    private SigningCertificate(BuilderImpl builder) {
        this.userName = builder.userName;
        this.certificateId = builder.certificateId;
        this.certificateBody = builder.certificateBody;
        this.status = builder.status;
        this.uploadDate = builder.uploadDate;
    }

    public String userName() {
        return this.userName;
    }

    public String certificateId() {
        return this.certificateId;
    }

    public String certificateBody() {
        return this.certificateBody;
    }

    public StatusType status() {
        return StatusType.fromValue(this.status);
    }

    public String statusString() {
        return this.status;
    }

    public Instant uploadDate() {
        return this.uploadDate;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.userName());
        hashCode = 31 * hashCode + Objects.hashCode(this.certificateId());
        hashCode = 31 * hashCode + Objects.hashCode(this.certificateBody());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusString());
        hashCode = 31 * hashCode + Objects.hashCode(this.uploadDate());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SigningCertificate)) {
            return false;
        }
        SigningCertificate other = (SigningCertificate)obj;
        return Objects.equals(this.userName(), other.userName()) && Objects.equals(this.certificateId(), other.certificateId()) && Objects.equals(this.certificateBody(), other.certificateBody()) && Objects.equals(this.statusString(), other.statusString()) && Objects.equals(this.uploadDate(), other.uploadDate());
    }

    public String toString() {
        return ToString.builder((String)"SigningCertificate").add("UserName", (Object)this.userName()).add("CertificateId", (Object)this.certificateId()).add("CertificateBody", (Object)this.certificateBody()).add("Status", (Object)this.statusString()).add("UploadDate", (Object)this.uploadDate()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "UserName": {
                return Optional.of(clazz.cast(this.userName()));
            }
            case "CertificateId": {
                return Optional.of(clazz.cast(this.certificateId()));
            }
            case "CertificateBody": {
                return Optional.of(clazz.cast(this.certificateBody()));
            }
            case "Status": {
                return Optional.of(clazz.cast(this.statusString()));
            }
            case "UploadDate": {
                return Optional.of(clazz.cast(this.uploadDate()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String userName;
        private String certificateId;
        private String certificateBody;
        private String status;
        private Instant uploadDate;

        private BuilderImpl() {
        }

        private BuilderImpl(SigningCertificate model) {
            this.userName(model.userName);
            this.certificateId(model.certificateId);
            this.certificateBody(model.certificateBody);
            this.status(model.status);
            this.uploadDate(model.uploadDate);
        }

        public final String getUserName() {
            return this.userName;
        }

        @Override
        public final Builder userName(String userName) {
            this.userName = userName;
            return this;
        }

        public final void setUserName(String userName) {
            this.userName = userName;
        }

        public final String getCertificateId() {
            return this.certificateId;
        }

        @Override
        public final Builder certificateId(String certificateId) {
            this.certificateId = certificateId;
            return this;
        }

        public final void setCertificateId(String certificateId) {
            this.certificateId = certificateId;
        }

        public final String getCertificateBody() {
            return this.certificateBody;
        }

        @Override
        public final Builder certificateBody(String certificateBody) {
            this.certificateBody = certificateBody;
            return this;
        }

        public final void setCertificateBody(String certificateBody) {
            this.certificateBody = certificateBody;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(StatusType status) {
            this.status(status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final Instant getUploadDate() {
            return this.uploadDate;
        }

        @Override
        public final Builder uploadDate(Instant uploadDate) {
            this.uploadDate = uploadDate;
            return this;
        }

        public final void setUploadDate(Instant uploadDate) {
            this.uploadDate = uploadDate;
        }

        public SigningCertificate build() {
            return new SigningCertificate(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, SigningCertificate> {
        public Builder userName(String var1);

        public Builder certificateId(String var1);

        public Builder certificateBody(String var1);

        public Builder status(String var1);

        public Builder status(StatusType var1);

        public Builder uploadDate(Instant var1);
    }
}

