/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.model;

import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class LoginProfile
implements ToCopyableBuilder<Builder, LoginProfile> {
    private final String userName;
    private final Instant createDate;
    private final Boolean passwordResetRequired;

    private LoginProfile(BuilderImpl builder) {
        this.userName = builder.userName;
        this.createDate = builder.createDate;
        this.passwordResetRequired = builder.passwordResetRequired;
    }

    public String userName() {
        return this.userName;
    }

    public Instant createDate() {
        return this.createDate;
    }

    public Boolean passwordResetRequired() {
        return this.passwordResetRequired;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.userName());
        hashCode = 31 * hashCode + Objects.hashCode(this.createDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.passwordResetRequired());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LoginProfile)) {
            return false;
        }
        LoginProfile other = (LoginProfile)obj;
        return Objects.equals(this.userName(), other.userName()) && Objects.equals(this.createDate(), other.createDate()) && Objects.equals(this.passwordResetRequired(), other.passwordResetRequired());
    }

    public String toString() {
        return ToString.builder((String)"LoginProfile").add("UserName", (Object)this.userName()).add("CreateDate", (Object)this.createDate()).add("PasswordResetRequired", (Object)this.passwordResetRequired()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "UserName": {
                return Optional.of(clazz.cast(this.userName()));
            }
            case "CreateDate": {
                return Optional.of(clazz.cast(this.createDate()));
            }
            case "PasswordResetRequired": {
                return Optional.of(clazz.cast(this.passwordResetRequired()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String userName;
        private Instant createDate;
        private Boolean passwordResetRequired;

        private BuilderImpl() {
        }

        private BuilderImpl(LoginProfile model) {
            this.userName(model.userName);
            this.createDate(model.createDate);
            this.passwordResetRequired(model.passwordResetRequired);
        }

        public final String getUserName() {
            return this.userName;
        }

        @Override
        public final Builder userName(String userName) {
            this.userName = userName;
            return this;
        }

        public final void setUserName(String userName) {
            this.userName = userName;
        }

        public final Instant getCreateDate() {
            return this.createDate;
        }

        @Override
        public final Builder createDate(Instant createDate) {
            this.createDate = createDate;
            return this;
        }

        public final void setCreateDate(Instant createDate) {
            this.createDate = createDate;
        }

        public final Boolean getPasswordResetRequired() {
            return this.passwordResetRequired;
        }

        @Override
        public final Builder passwordResetRequired(Boolean passwordResetRequired) {
            this.passwordResetRequired = passwordResetRequired;
            return this;
        }

        public final void setPasswordResetRequired(Boolean passwordResetRequired) {
            this.passwordResetRequired = passwordResetRequired;
        }

        public LoginProfile build() {
            return new LoginProfile(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, LoginProfile> {
        public Builder userName(String var1);

        public Builder createDate(Instant var1);

        public Builder passwordResetRequired(Boolean var1);
    }
}

