/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.iam.model.IAMRequest;
import software.amazon.awssdk.services.iam.model.SimulationPolicyListTypeCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class GetContextKeysForPrincipalPolicyRequest
extends IAMRequest
implements ToCopyableBuilder<Builder, GetContextKeysForPrincipalPolicyRequest> {
    private final String policySourceArn;
    private final List<String> policyInputList;

    private GetContextKeysForPrincipalPolicyRequest(BuilderImpl builder) {
        super(builder);
        this.policySourceArn = builder.policySourceArn;
        this.policyInputList = builder.policyInputList;
    }

    public String policySourceArn() {
        return this.policySourceArn;
    }

    public List<String> policyInputList() {
        return this.policyInputList;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.policySourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.policyInputList());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetContextKeysForPrincipalPolicyRequest)) {
            return false;
        }
        GetContextKeysForPrincipalPolicyRequest other = (GetContextKeysForPrincipalPolicyRequest)((Object)obj);
        return Objects.equals(this.policySourceArn(), other.policySourceArn()) && Objects.equals(this.policyInputList(), other.policyInputList());
    }

    public String toString() {
        return ToString.builder((String)"GetContextKeysForPrincipalPolicyRequest").add("PolicySourceArn", (Object)this.policySourceArn()).add("PolicyInputList", this.policyInputList()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PolicySourceArn": {
                return Optional.of(clazz.cast(this.policySourceArn()));
            }
            case "PolicyInputList": {
                return Optional.of(clazz.cast(this.policyInputList()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends IAMRequest.BuilderImpl
    implements Builder {
        private String policySourceArn;
        private List<String> policyInputList;

        private BuilderImpl() {
        }

        private BuilderImpl(GetContextKeysForPrincipalPolicyRequest model) {
            this.policySourceArn(model.policySourceArn);
            this.policyInputList(model.policyInputList);
        }

        public final String getPolicySourceArn() {
            return this.policySourceArn;
        }

        @Override
        public final Builder policySourceArn(String policySourceArn) {
            this.policySourceArn = policySourceArn;
            return this;
        }

        public final void setPolicySourceArn(String policySourceArn) {
            this.policySourceArn = policySourceArn;
        }

        public final Collection<String> getPolicyInputList() {
            return this.policyInputList;
        }

        @Override
        public final Builder policyInputList(Collection<String> policyInputList) {
            this.policyInputList = SimulationPolicyListTypeCopier.copy(policyInputList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder policyInputList(String ... policyInputList) {
            this.policyInputList(Arrays.asList(policyInputList));
            return this;
        }

        public final void setPolicyInputList(Collection<String> policyInputList) {
            this.policyInputList = SimulationPolicyListTypeCopier.copy(policyInputList);
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public GetContextKeysForPrincipalPolicyRequest build() {
            return new GetContextKeysForPrincipalPolicyRequest(this);
        }
    }

    public static interface Builder
    extends IAMRequest.Builder,
    CopyableBuilder<Builder, GetContextKeysForPrincipalPolicyRequest> {
        public Builder policySourceArn(String var1);

        public Builder policyInputList(Collection<String> var1);

        public Builder policyInputList(String ... var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

