/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.services.iam.model.GroupDetail;
import software.amazon.awssdk.services.iam.model.IAMResponse;
import software.amazon.awssdk.services.iam.model.ManagedPolicyDetail;
import software.amazon.awssdk.services.iam.model.ManagedPolicyDetailListTypeCopier;
import software.amazon.awssdk.services.iam.model.RoleDetail;
import software.amazon.awssdk.services.iam.model.UserDetail;
import software.amazon.awssdk.services.iam.model._groupDetailListTypeCopier;
import software.amazon.awssdk.services.iam.model._roleDetailListTypeCopier;
import software.amazon.awssdk.services.iam.model._userDetailListTypeCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class GetAccountAuthorizationDetailsResponse
extends IAMResponse
implements ToCopyableBuilder<Builder, GetAccountAuthorizationDetailsResponse> {
    private final List<UserDetail> userDetailList;
    private final List<GroupDetail> groupDetailList;
    private final List<RoleDetail> roleDetailList;
    private final List<ManagedPolicyDetail> policies;
    private final Boolean isTruncated;
    private final String marker;

    private GetAccountAuthorizationDetailsResponse(BuilderImpl builder) {
        super(builder);
        this.userDetailList = builder.userDetailList;
        this.groupDetailList = builder.groupDetailList;
        this.roleDetailList = builder.roleDetailList;
        this.policies = builder.policies;
        this.isTruncated = builder.isTruncated;
        this.marker = builder.marker;
    }

    public List<UserDetail> userDetailList() {
        return this.userDetailList;
    }

    public List<GroupDetail> groupDetailList() {
        return this.groupDetailList;
    }

    public List<RoleDetail> roleDetailList() {
        return this.roleDetailList;
    }

    public List<ManagedPolicyDetail> policies() {
        return this.policies;
    }

    public Boolean isTruncated() {
        return this.isTruncated;
    }

    public String marker() {
        return this.marker;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.userDetailList());
        hashCode = 31 * hashCode + Objects.hashCode(this.groupDetailList());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleDetailList());
        hashCode = 31 * hashCode + Objects.hashCode(this.policies());
        hashCode = 31 * hashCode + Objects.hashCode(this.isTruncated());
        hashCode = 31 * hashCode + Objects.hashCode(this.marker());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetAccountAuthorizationDetailsResponse)) {
            return false;
        }
        GetAccountAuthorizationDetailsResponse other = (GetAccountAuthorizationDetailsResponse)((Object)obj);
        return Objects.equals(this.userDetailList(), other.userDetailList()) && Objects.equals(this.groupDetailList(), other.groupDetailList()) && Objects.equals(this.roleDetailList(), other.roleDetailList()) && Objects.equals(this.policies(), other.policies()) && Objects.equals(this.isTruncated(), other.isTruncated()) && Objects.equals(this.marker(), other.marker());
    }

    public String toString() {
        return ToString.builder((String)"GetAccountAuthorizationDetailsResponse").add("UserDetailList", this.userDetailList()).add("GroupDetailList", this.groupDetailList()).add("RoleDetailList", this.roleDetailList()).add("Policies", this.policies()).add("IsTruncated", (Object)this.isTruncated()).add("Marker", (Object)this.marker()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "UserDetailList": {
                return Optional.of(clazz.cast(this.userDetailList()));
            }
            case "GroupDetailList": {
                return Optional.of(clazz.cast(this.groupDetailList()));
            }
            case "RoleDetailList": {
                return Optional.of(clazz.cast(this.roleDetailList()));
            }
            case "Policies": {
                return Optional.of(clazz.cast(this.policies()));
            }
            case "IsTruncated": {
                return Optional.of(clazz.cast(this.isTruncated()));
            }
            case "Marker": {
                return Optional.of(clazz.cast(this.marker()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends IAMResponse.BuilderImpl
    implements Builder {
        private List<UserDetail> userDetailList;
        private List<GroupDetail> groupDetailList;
        private List<RoleDetail> roleDetailList;
        private List<ManagedPolicyDetail> policies;
        private Boolean isTruncated;
        private String marker;

        private BuilderImpl() {
        }

        private BuilderImpl(GetAccountAuthorizationDetailsResponse model) {
            this.userDetailList(model.userDetailList);
            this.groupDetailList(model.groupDetailList);
            this.roleDetailList(model.roleDetailList);
            this.policies(model.policies);
            this.isTruncated(model.isTruncated);
            this.marker(model.marker);
        }

        public final Collection<UserDetail.Builder> getUserDetailList() {
            return this.userDetailList != null ? (Collection)this.userDetailList.stream().map(UserDetail::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder userDetailList(Collection<UserDetail> userDetailList) {
            this.userDetailList = _userDetailListTypeCopier.copy(userDetailList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder userDetailList(UserDetail ... userDetailList) {
            this.userDetailList(Arrays.asList(userDetailList));
            return this;
        }

        public final void setUserDetailList(Collection<UserDetail.BuilderImpl> userDetailList) {
            this.userDetailList = _userDetailListTypeCopier.copyFromBuilder(userDetailList);
        }

        public final Collection<GroupDetail.Builder> getGroupDetailList() {
            return this.groupDetailList != null ? (Collection)this.groupDetailList.stream().map(GroupDetail::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder groupDetailList(Collection<GroupDetail> groupDetailList) {
            this.groupDetailList = _groupDetailListTypeCopier.copy(groupDetailList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groupDetailList(GroupDetail ... groupDetailList) {
            this.groupDetailList(Arrays.asList(groupDetailList));
            return this;
        }

        public final void setGroupDetailList(Collection<GroupDetail.BuilderImpl> groupDetailList) {
            this.groupDetailList = _groupDetailListTypeCopier.copyFromBuilder(groupDetailList);
        }

        public final Collection<RoleDetail.Builder> getRoleDetailList() {
            return this.roleDetailList != null ? (Collection)this.roleDetailList.stream().map(RoleDetail::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder roleDetailList(Collection<RoleDetail> roleDetailList) {
            this.roleDetailList = _roleDetailListTypeCopier.copy(roleDetailList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder roleDetailList(RoleDetail ... roleDetailList) {
            this.roleDetailList(Arrays.asList(roleDetailList));
            return this;
        }

        public final void setRoleDetailList(Collection<RoleDetail.BuilderImpl> roleDetailList) {
            this.roleDetailList = _roleDetailListTypeCopier.copyFromBuilder(roleDetailList);
        }

        public final Collection<ManagedPolicyDetail.Builder> getPolicies() {
            return this.policies != null ? (Collection)this.policies.stream().map(ManagedPolicyDetail::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder policies(Collection<ManagedPolicyDetail> policies) {
            this.policies = ManagedPolicyDetailListTypeCopier.copy(policies);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder policies(ManagedPolicyDetail ... policies) {
            this.policies(Arrays.asList(policies));
            return this;
        }

        public final void setPolicies(Collection<ManagedPolicyDetail.BuilderImpl> policies) {
            this.policies = ManagedPolicyDetailListTypeCopier.copyFromBuilder(policies);
        }

        public final Boolean getIsTruncated() {
            return this.isTruncated;
        }

        @Override
        public final Builder isTruncated(Boolean isTruncated) {
            this.isTruncated = isTruncated;
            return this;
        }

        public final void setIsTruncated(Boolean isTruncated) {
            this.isTruncated = isTruncated;
        }

        public final String getMarker() {
            return this.marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        public GetAccountAuthorizationDetailsResponse build() {
            return new GetAccountAuthorizationDetailsResponse(this);
        }
    }

    public static interface Builder
    extends IAMResponse.Builder,
    CopyableBuilder<Builder, GetAccountAuthorizationDetailsResponse> {
        public Builder userDetailList(Collection<UserDetail> var1);

        public Builder userDetailList(UserDetail ... var1);

        public Builder groupDetailList(Collection<GroupDetail> var1);

        public Builder groupDetailList(GroupDetail ... var1);

        public Builder roleDetailList(Collection<RoleDetail> var1);

        public Builder roleDetailList(RoleDetail ... var1);

        public Builder policies(Collection<ManagedPolicyDetail> var1);

        public Builder policies(ManagedPolicyDetail ... var1);

        public Builder isTruncated(Boolean var1);

        public Builder marker(String var1);
    }
}

