/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.transform;

import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.iam.model.ResetServiceSpecificCredentialRequest;

public class ResetServiceSpecificCredentialRequestMarshaller
implements Marshaller<Request<ResetServiceSpecificCredentialRequest>, ResetServiceSpecificCredentialRequest> {
    public Request<ResetServiceSpecificCredentialRequest> marshall(ResetServiceSpecificCredentialRequest resetServiceSpecificCredentialRequest) {
        if (resetServiceSpecificCredentialRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((Object)resetServiceSpecificCredentialRequest, "IAMClient");
        request.addParameter("Action", "ResetServiceSpecificCredential");
        request.addParameter("Version", "2010-05-08");
        request.setHttpMethod(HttpMethodName.POST);
        if (resetServiceSpecificCredentialRequest.userName() != null) {
            request.addParameter("UserName", StringUtils.fromString((String)resetServiceSpecificCredentialRequest.userName()));
        }
        if (resetServiceSpecificCredentialRequest.serviceSpecificCredentialId() != null) {
            request.addParameter("ServiceSpecificCredentialId", StringUtils.fromString((String)resetServiceSpecificCredentialRequest.serviceSpecificCredentialId()));
        }
        return request;
    }
}

