/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.transform;

import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.iam.model.CreateSAMLProviderRequest;

public class CreateSAMLProviderRequestMarshaller
implements Marshaller<Request<CreateSAMLProviderRequest>, CreateSAMLProviderRequest> {
    public Request<CreateSAMLProviderRequest> marshall(CreateSAMLProviderRequest createSAMLProviderRequest) {
        if (createSAMLProviderRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((Object)createSAMLProviderRequest, "IAMClient");
        request.addParameter("Action", "CreateSAMLProvider");
        request.addParameter("Version", "2010-05-08");
        request.setHttpMethod(HttpMethodName.POST);
        if (createSAMLProviderRequest.samlMetadataDocument() != null) {
            request.addParameter("SAMLMetadataDocument", StringUtils.fromString((String)createSAMLProviderRequest.samlMetadataDocument()));
        }
        if (createSAMLProviderRequest.name() != null) {
            request.addParameter("Name", StringUtils.fromString((String)createSAMLProviderRequest.name()));
        }
        return request;
    }
}

