/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.paginators;

import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.NextPageFetcher;
import software.amazon.awssdk.core.pagination.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.services.iam.IAMClient;
import software.amazon.awssdk.services.iam.model.ListServerCertificatesRequest;
import software.amazon.awssdk.services.iam.model.ListServerCertificatesResponse;
import software.amazon.awssdk.services.iam.model.ServerCertificateMetadata;

public final class ListServerCertificatesPaginator
implements SdkIterable<ListServerCertificatesResponse> {
    private final IAMClient client;
    private final ListServerCertificatesRequest firstRequest;
    private final NextPageFetcher nextPageFetcher;

    public ListServerCertificatesPaginator(IAMClient client, ListServerCertificatesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListServerCertificatesResponseFetcher();
    }

    public Iterator<ListServerCertificatesResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    public SdkIterable<ServerCertificateMetadata> serverCertificateMetadataList() {
        Function<ListServerCertificatesResponse, Iterator> getIterator = response -> response != null ? response.serverCertificateMetadataList().iterator() : null;
        return new PaginatedItemsIterable((SdkIterable)this, getIterator);
    }

    private class ListServerCertificatesResponseFetcher
    implements NextPageFetcher<ListServerCertificatesResponse> {
        private ListServerCertificatesResponseFetcher() {
        }

        public boolean hasNextPage(ListServerCertificatesResponse previousPage) {
            return previousPage.isTruncated();
        }

        public ListServerCertificatesResponse nextPage(ListServerCertificatesResponse previousPage) {
            if (previousPage == null) {
                return ListServerCertificatesPaginator.this.client.listServerCertificates(ListServerCertificatesPaginator.this.firstRequest);
            }
            return ListServerCertificatesPaginator.this.client.listServerCertificates((ListServerCertificatesRequest)((Object)ListServerCertificatesPaginator.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

