/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.paginators;

import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.NextPageFetcher;
import software.amazon.awssdk.core.pagination.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.services.iam.IAMClient;
import software.amazon.awssdk.services.iam.model.ListMFADevicesRequest;
import software.amazon.awssdk.services.iam.model.ListMFADevicesResponse;
import software.amazon.awssdk.services.iam.model.MFADevice;

public final class ListMFADevicesPaginator
implements SdkIterable<ListMFADevicesResponse> {
    private final IAMClient client;
    private final ListMFADevicesRequest firstRequest;
    private final NextPageFetcher nextPageFetcher;

    public ListMFADevicesPaginator(IAMClient client, ListMFADevicesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListMFADevicesResponseFetcher();
    }

    public Iterator<ListMFADevicesResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    public SdkIterable<MFADevice> mfaDevices() {
        Function<ListMFADevicesResponse, Iterator> getIterator = response -> response != null ? response.mfaDevices().iterator() : null;
        return new PaginatedItemsIterable((SdkIterable)this, getIterator);
    }

    private class ListMFADevicesResponseFetcher
    implements NextPageFetcher<ListMFADevicesResponse> {
        private ListMFADevicesResponseFetcher() {
        }

        public boolean hasNextPage(ListMFADevicesResponse previousPage) {
            return previousPage.isTruncated();
        }

        public ListMFADevicesResponse nextPage(ListMFADevicesResponse previousPage) {
            if (previousPage == null) {
                return ListMFADevicesPaginator.this.client.listMFADevices(ListMFADevicesPaginator.this.firstRequest);
            }
            return ListMFADevicesPaginator.this.client.listMFADevices((ListMFADevicesRequest)((Object)ListMFADevicesPaginator.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

