/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.paginators;

import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.NextPageFetcher;
import software.amazon.awssdk.core.pagination.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.services.iam.IAMClient;
import software.amazon.awssdk.services.iam.model.ListAccountAliasesRequest;
import software.amazon.awssdk.services.iam.model.ListAccountAliasesResponse;

public final class ListAccountAliasesPaginator
implements SdkIterable<ListAccountAliasesResponse> {
    private final IAMClient client;
    private final ListAccountAliasesRequest firstRequest;
    private final NextPageFetcher nextPageFetcher;

    public ListAccountAliasesPaginator(IAMClient client, ListAccountAliasesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListAccountAliasesResponseFetcher();
    }

    public Iterator<ListAccountAliasesResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    public SdkIterable<String> accountAliases() {
        Function<ListAccountAliasesResponse, Iterator> getIterator = response -> response != null ? response.accountAliases().iterator() : null;
        return new PaginatedItemsIterable((SdkIterable)this, getIterator);
    }

    private class ListAccountAliasesResponseFetcher
    implements NextPageFetcher<ListAccountAliasesResponse> {
        private ListAccountAliasesResponseFetcher() {
        }

        public boolean hasNextPage(ListAccountAliasesResponse previousPage) {
            return previousPage.isTruncated();
        }

        public ListAccountAliasesResponse nextPage(ListAccountAliasesResponse previousPage) {
            if (previousPage == null) {
                return ListAccountAliasesPaginator.this.client.listAccountAliases(ListAccountAliasesPaginator.this.firstRequest);
            }
            return ListAccountAliasesPaginator.this.client.listAccountAliases((ListAccountAliasesRequest)((Object)ListAccountAliasesPaginator.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

