/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.iam.model.IAMRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListServiceSpecificCredentialsRequest
extends IAMRequest
implements ToCopyableBuilder<Builder, ListServiceSpecificCredentialsRequest> {
    private final String userName;
    private final String serviceName;

    private ListServiceSpecificCredentialsRequest(BuilderImpl builder) {
        super(builder);
        this.userName = builder.userName;
        this.serviceName = builder.serviceName;
    }

    public String userName() {
        return this.userName;
    }

    public String serviceName() {
        return this.serviceName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.userName());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceName());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListServiceSpecificCredentialsRequest)) {
            return false;
        }
        ListServiceSpecificCredentialsRequest other = (ListServiceSpecificCredentialsRequest)((Object)obj);
        return Objects.equals(this.userName(), other.userName()) && Objects.equals(this.serviceName(), other.serviceName());
    }

    public String toString() {
        return ToString.builder((String)"ListServiceSpecificCredentialsRequest").add("UserName", (Object)this.userName()).add("ServiceName", (Object)this.serviceName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "UserName": {
                return Optional.of(clazz.cast(this.userName()));
            }
            case "ServiceName": {
                return Optional.of(clazz.cast(this.serviceName()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends IAMRequest.BuilderImpl
    implements Builder {
        private String userName;
        private String serviceName;

        private BuilderImpl() {
        }

        private BuilderImpl(ListServiceSpecificCredentialsRequest model) {
            this.userName(model.userName);
            this.serviceName(model.serviceName);
        }

        public final String getUserName() {
            return this.userName;
        }

        @Override
        public final Builder userName(String userName) {
            this.userName = userName;
            return this;
        }

        public final void setUserName(String userName) {
            this.userName = userName;
        }

        public final String getServiceName() {
            return this.serviceName;
        }

        @Override
        public final Builder serviceName(String serviceName) {
            this.serviceName = serviceName;
            return this;
        }

        public final void setServiceName(String serviceName) {
            this.serviceName = serviceName;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public ListServiceSpecificCredentialsRequest build() {
            return new ListServiceSpecificCredentialsRequest(this);
        }
    }

    public static interface Builder
    extends IAMRequest.Builder,
    CopyableBuilder<Builder, ListServiceSpecificCredentialsRequest> {
        public Builder userName(String var1);

        public Builder serviceName(String var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

