/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.iam.model.IAMRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class AttachRolePolicyRequest
extends IAMRequest
implements ToCopyableBuilder<Builder, AttachRolePolicyRequest> {
    private final String roleName;
    private final String policyArn;

    private AttachRolePolicyRequest(BuilderImpl builder) {
        super(builder);
        this.roleName = builder.roleName;
        this.policyArn = builder.policyArn;
    }

    public String roleName() {
        return this.roleName;
    }

    public String policyArn() {
        return this.policyArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.roleName());
        hashCode = 31 * hashCode + Objects.hashCode(this.policyArn());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AttachRolePolicyRequest)) {
            return false;
        }
        AttachRolePolicyRequest other = (AttachRolePolicyRequest)((Object)obj);
        return Objects.equals(this.roleName(), other.roleName()) && Objects.equals(this.policyArn(), other.policyArn());
    }

    public String toString() {
        return ToString.builder((String)"AttachRolePolicyRequest").add("RoleName", (Object)this.roleName()).add("PolicyArn", (Object)this.policyArn()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RoleName": {
                return Optional.of(clazz.cast(this.roleName()));
            }
            case "PolicyArn": {
                return Optional.of(clazz.cast(this.policyArn()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends IAMRequest.BuilderImpl
    implements Builder {
        private String roleName;
        private String policyArn;

        private BuilderImpl() {
        }

        private BuilderImpl(AttachRolePolicyRequest model) {
            this.roleName(model.roleName);
            this.policyArn(model.policyArn);
        }

        public final String getRoleName() {
            return this.roleName;
        }

        @Override
        public final Builder roleName(String roleName) {
            this.roleName = roleName;
            return this;
        }

        public final void setRoleName(String roleName) {
            this.roleName = roleName;
        }

        public final String getPolicyArn() {
            return this.policyArn;
        }

        @Override
        public final Builder policyArn(String policyArn) {
            this.policyArn = policyArn;
            return this;
        }

        public final void setPolicyArn(String policyArn) {
            this.policyArn = policyArn;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public AttachRolePolicyRequest build() {
            return new AttachRolePolicyRequest(this);
        }
    }

    public static interface Builder
    extends IAMRequest.Builder,
    CopyableBuilder<Builder, AttachRolePolicyRequest> {
        public Builder roleName(String var1);

        public Builder policyArn(String var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

