/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.paginators;

import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.NextPageFetcher;
import software.amazon.awssdk.core.pagination.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.services.iam.IAMClient;
import software.amazon.awssdk.services.iam.model.ListRolesRequest;
import software.amazon.awssdk.services.iam.model.ListRolesResponse;
import software.amazon.awssdk.services.iam.model.Role;

public final class ListRolesPaginator
implements SdkIterable<ListRolesResponse> {
    private final IAMClient client;
    private final ListRolesRequest firstRequest;
    private final NextPageFetcher nextPageFetcher;

    public ListRolesPaginator(IAMClient client, ListRolesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListRolesResponseFetcher();
    }

    public Iterator<ListRolesResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    public SdkIterable<Role> roles() {
        Function<ListRolesResponse, Iterator> getIterator = response -> response != null ? response.roles().iterator() : null;
        return new PaginatedItemsIterable((SdkIterable)this, getIterator);
    }

    private class ListRolesResponseFetcher
    implements NextPageFetcher<ListRolesResponse> {
        private ListRolesResponseFetcher() {
        }

        public boolean hasNextPage(ListRolesResponse previousPage) {
            return previousPage.isTruncated();
        }

        public ListRolesResponse nextPage(ListRolesResponse previousPage) {
            if (previousPage == null) {
                return ListRolesPaginator.this.client.listRoles(ListRolesPaginator.this.firstRequest);
            }
            return ListRolesPaginator.this.client.listRoles((ListRolesRequest)((Object)ListRolesPaginator.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

