/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.paginators;

import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.NextPageFetcher;
import software.amazon.awssdk.core.pagination.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.services.iam.IAMClient;
import software.amazon.awssdk.services.iam.model.InstanceProfile;
import software.amazon.awssdk.services.iam.model.ListInstanceProfilesRequest;
import software.amazon.awssdk.services.iam.model.ListInstanceProfilesResponse;

public final class ListInstanceProfilesPaginator
implements SdkIterable<ListInstanceProfilesResponse> {
    private final IAMClient client;
    private final ListInstanceProfilesRequest firstRequest;
    private final NextPageFetcher nextPageFetcher;

    public ListInstanceProfilesPaginator(IAMClient client, ListInstanceProfilesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListInstanceProfilesResponseFetcher();
    }

    public Iterator<ListInstanceProfilesResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    public SdkIterable<InstanceProfile> instanceProfiles() {
        Function<ListInstanceProfilesResponse, Iterator> getIterator = response -> response != null ? response.instanceProfiles().iterator() : null;
        return new PaginatedItemsIterable((SdkIterable)this, getIterator);
    }

    private class ListInstanceProfilesResponseFetcher
    implements NextPageFetcher<ListInstanceProfilesResponse> {
        private ListInstanceProfilesResponseFetcher() {
        }

        public boolean hasNextPage(ListInstanceProfilesResponse previousPage) {
            return previousPage.isTruncated();
        }

        public ListInstanceProfilesResponse nextPage(ListInstanceProfilesResponse previousPage) {
            if (previousPage == null) {
                return ListInstanceProfilesPaginator.this.client.listInstanceProfiles(ListInstanceProfilesPaginator.this.firstRequest);
            }
            return ListInstanceProfilesPaginator.this.client.listInstanceProfiles((ListInstanceProfilesRequest)((Object)ListInstanceProfilesPaginator.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

