/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.paginators;

import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.NextPageFetcher;
import software.amazon.awssdk.core.pagination.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.services.iam.IAMClient;
import software.amazon.awssdk.services.iam.model.GetGroupRequest;
import software.amazon.awssdk.services.iam.model.GetGroupResponse;
import software.amazon.awssdk.services.iam.model.User;

public final class GetGroupPaginator
implements SdkIterable<GetGroupResponse> {
    private final IAMClient client;
    private final GetGroupRequest firstRequest;
    private final NextPageFetcher nextPageFetcher;

    public GetGroupPaginator(IAMClient client, GetGroupRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new GetGroupResponseFetcher();
    }

    public Iterator<GetGroupResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    public SdkIterable<User> users() {
        Function<GetGroupResponse, Iterator> getIterator = response -> response != null ? response.users().iterator() : null;
        return new PaginatedItemsIterable((SdkIterable)this, getIterator);
    }

    private class GetGroupResponseFetcher
    implements NextPageFetcher<GetGroupResponse> {
        private GetGroupResponseFetcher() {
        }

        public boolean hasNextPage(GetGroupResponse previousPage) {
            return previousPage.isTruncated();
        }

        public GetGroupResponse nextPage(GetGroupResponse previousPage) {
            if (previousPage == null) {
                return GetGroupPaginator.this.client.getGroup(GetGroupPaginator.this.firstRequest);
            }
            return GetGroupPaginator.this.client.getGroup((GetGroupRequest)((Object)GetGroupPaginator.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

