/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.iam.model.IAMRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class UpdateSAMLProviderRequest
extends IAMRequest
implements ToCopyableBuilder<Builder, UpdateSAMLProviderRequest> {
    private final String samlMetadataDocument;
    private final String samlProviderArn;

    private UpdateSAMLProviderRequest(BuilderImpl builder) {
        super(builder);
        this.samlMetadataDocument = builder.samlMetadataDocument;
        this.samlProviderArn = builder.samlProviderArn;
    }

    public String samlMetadataDocument() {
        return this.samlMetadataDocument;
    }

    public String samlProviderArn() {
        return this.samlProviderArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.samlMetadataDocument());
        hashCode = 31 * hashCode + Objects.hashCode(this.samlProviderArn());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateSAMLProviderRequest)) {
            return false;
        }
        UpdateSAMLProviderRequest other = (UpdateSAMLProviderRequest)((Object)obj);
        return Objects.equals(this.samlMetadataDocument(), other.samlMetadataDocument()) && Objects.equals(this.samlProviderArn(), other.samlProviderArn());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.samlMetadataDocument() != null) {
            sb.append("SAMLMetadataDocument: ").append(this.samlMetadataDocument()).append(",");
        }
        if (this.samlProviderArn() != null) {
            sb.append("SAMLProviderArn: ").append(this.samlProviderArn()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SAMLMetadataDocument": {
                return Optional.of(clazz.cast(this.samlMetadataDocument()));
            }
            case "SAMLProviderArn": {
                return Optional.of(clazz.cast(this.samlProviderArn()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends IAMRequest.BuilderImpl
    implements Builder {
        private String samlMetadataDocument;
        private String samlProviderArn;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateSAMLProviderRequest model) {
            this.samlMetadataDocument(model.samlMetadataDocument);
            this.samlProviderArn(model.samlProviderArn);
        }

        public final String getSAMLMetadataDocument() {
            return this.samlMetadataDocument;
        }

        @Override
        public final Builder samlMetadataDocument(String samlMetadataDocument) {
            this.samlMetadataDocument = samlMetadataDocument;
            return this;
        }

        public final void setSAMLMetadataDocument(String samlMetadataDocument) {
            this.samlMetadataDocument = samlMetadataDocument;
        }

        public final String getSAMLProviderArn() {
            return this.samlProviderArn;
        }

        @Override
        public final Builder samlProviderArn(String samlProviderArn) {
            this.samlProviderArn = samlProviderArn;
            return this;
        }

        public final void setSAMLProviderArn(String samlProviderArn) {
            this.samlProviderArn = samlProviderArn;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public UpdateSAMLProviderRequest build() {
            return new UpdateSAMLProviderRequest(this);
        }
    }

    public static interface Builder
    extends IAMRequest.Builder,
    CopyableBuilder<Builder, UpdateSAMLProviderRequest> {
        public Builder samlMetadataDocument(String var1);

        public Builder samlProviderArn(String var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

