/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.iam.model.IAMRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class UpdateLoginProfileRequest
extends IAMRequest
implements ToCopyableBuilder<Builder, UpdateLoginProfileRequest> {
    private final String userName;
    private final String password;
    private final Boolean passwordResetRequired;

    private UpdateLoginProfileRequest(BuilderImpl builder) {
        super(builder);
        this.userName = builder.userName;
        this.password = builder.password;
        this.passwordResetRequired = builder.passwordResetRequired;
    }

    public String userName() {
        return this.userName;
    }

    public String password() {
        return this.password;
    }

    public Boolean passwordResetRequired() {
        return this.passwordResetRequired;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.userName());
        hashCode = 31 * hashCode + Objects.hashCode(this.password());
        hashCode = 31 * hashCode + Objects.hashCode(this.passwordResetRequired());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateLoginProfileRequest)) {
            return false;
        }
        UpdateLoginProfileRequest other = (UpdateLoginProfileRequest)((Object)obj);
        return Objects.equals(this.userName(), other.userName()) && Objects.equals(this.password(), other.password()) && Objects.equals(this.passwordResetRequired(), other.passwordResetRequired());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.userName() != null) {
            sb.append("UserName: ").append(this.userName()).append(",");
        }
        if (this.password() != null) {
            sb.append("Password: ").append(this.password()).append(",");
        }
        if (this.passwordResetRequired() != null) {
            sb.append("PasswordResetRequired: ").append(this.passwordResetRequired()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "UserName": {
                return Optional.of(clazz.cast(this.userName()));
            }
            case "Password": {
                return Optional.of(clazz.cast(this.password()));
            }
            case "PasswordResetRequired": {
                return Optional.of(clazz.cast(this.passwordResetRequired()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends IAMRequest.BuilderImpl
    implements Builder {
        private String userName;
        private String password;
        private Boolean passwordResetRequired;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateLoginProfileRequest model) {
            this.userName(model.userName);
            this.password(model.password);
            this.passwordResetRequired(model.passwordResetRequired);
        }

        public final String getUserName() {
            return this.userName;
        }

        @Override
        public final Builder userName(String userName) {
            this.userName = userName;
            return this;
        }

        public final void setUserName(String userName) {
            this.userName = userName;
        }

        public final String getPassword() {
            return this.password;
        }

        @Override
        public final Builder password(String password) {
            this.password = password;
            return this;
        }

        public final void setPassword(String password) {
            this.password = password;
        }

        public final Boolean getPasswordResetRequired() {
            return this.passwordResetRequired;
        }

        @Override
        public final Builder passwordResetRequired(Boolean passwordResetRequired) {
            this.passwordResetRequired = passwordResetRequired;
            return this;
        }

        public final void setPasswordResetRequired(Boolean passwordResetRequired) {
            this.passwordResetRequired = passwordResetRequired;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public UpdateLoginProfileRequest build() {
            return new UpdateLoginProfileRequest(this);
        }
    }

    public static interface Builder
    extends IAMRequest.Builder,
    CopyableBuilder<Builder, UpdateLoginProfileRequest> {
        public Builder userName(String var1);

        public Builder password(String var1);

        public Builder passwordResetRequired(Boolean var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

