/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.transform;

import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.iam.model.UpdateSSHPublicKeyRequest;

public class UpdateSSHPublicKeyRequestMarshaller
implements Marshaller<Request<UpdateSSHPublicKeyRequest>, UpdateSSHPublicKeyRequest> {
    public Request<UpdateSSHPublicKeyRequest> marshall(UpdateSSHPublicKeyRequest updateSSHPublicKeyRequest) {
        if (updateSSHPublicKeyRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)updateSSHPublicKeyRequest, "IAMClient");
        request.addParameter("Action", "UpdateSSHPublicKey");
        request.addParameter("Version", "2010-05-08");
        request.setHttpMethod(HttpMethodName.POST);
        if (updateSSHPublicKeyRequest.userName() != null) {
            request.addParameter("UserName", StringUtils.fromString((String)updateSSHPublicKeyRequest.userName()));
        }
        if (updateSSHPublicKeyRequest.sshPublicKeyId() != null) {
            request.addParameter("SSHPublicKeyId", StringUtils.fromString((String)updateSSHPublicKeyRequest.sshPublicKeyId()));
        }
        if (updateSSHPublicKeyRequest.statusString() != null) {
            request.addParameter("Status", StringUtils.fromString((String)updateSSHPublicKeyRequest.statusString()));
        }
        return request;
    }
}

