/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.transform;

import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.iam.model.ListServerCertificatesRequest;

public class ListServerCertificatesRequestMarshaller
implements Marshaller<Request<ListServerCertificatesRequest>, ListServerCertificatesRequest> {
    public Request<ListServerCertificatesRequest> marshall(ListServerCertificatesRequest listServerCertificatesRequest) {
        if (listServerCertificatesRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)listServerCertificatesRequest, "IAMClient");
        request.addParameter("Action", "ListServerCertificates");
        request.addParameter("Version", "2010-05-08");
        request.setHttpMethod(HttpMethodName.POST);
        if (listServerCertificatesRequest.pathPrefix() != null) {
            request.addParameter("PathPrefix", StringUtils.fromString((String)listServerCertificatesRequest.pathPrefix()));
        }
        if (listServerCertificatesRequest.marker() != null) {
            request.addParameter("Marker", StringUtils.fromString((String)listServerCertificatesRequest.marker()));
        }
        if (listServerCertificatesRequest.maxItems() != null) {
            request.addParameter("MaxItems", StringUtils.fromInteger((Integer)listServerCertificatesRequest.maxItems()));
        }
        return request;
    }
}

