/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.transform;

import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.iam.model.ListRolePoliciesRequest;

public class ListRolePoliciesRequestMarshaller
implements Marshaller<Request<ListRolePoliciesRequest>, ListRolePoliciesRequest> {
    public Request<ListRolePoliciesRequest> marshall(ListRolePoliciesRequest listRolePoliciesRequest) {
        if (listRolePoliciesRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)listRolePoliciesRequest, "IAMClient");
        request.addParameter("Action", "ListRolePolicies");
        request.addParameter("Version", "2010-05-08");
        request.setHttpMethod(HttpMethodName.POST);
        if (listRolePoliciesRequest.roleName() != null) {
            request.addParameter("RoleName", StringUtils.fromString((String)listRolePoliciesRequest.roleName()));
        }
        if (listRolePoliciesRequest.marker() != null) {
            request.addParameter("Marker", StringUtils.fromString((String)listRolePoliciesRequest.marker()));
        }
        if (listRolePoliciesRequest.maxItems() != null) {
            request.addParameter("MaxItems", StringUtils.fromInteger((Integer)listRolePoliciesRequest.maxItems()));
        }
        return request;
    }
}

