/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.transform;

import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.iam.model.DetachRolePolicyRequest;

public class DetachRolePolicyRequestMarshaller
implements Marshaller<Request<DetachRolePolicyRequest>, DetachRolePolicyRequest> {
    public Request<DetachRolePolicyRequest> marshall(DetachRolePolicyRequest detachRolePolicyRequest) {
        if (detachRolePolicyRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)detachRolePolicyRequest, "IAMClient");
        request.addParameter("Action", "DetachRolePolicy");
        request.addParameter("Version", "2010-05-08");
        request.setHttpMethod(HttpMethodName.POST);
        if (detachRolePolicyRequest.roleName() != null) {
            request.addParameter("RoleName", StringUtils.fromString((String)detachRolePolicyRequest.roleName()));
        }
        if (detachRolePolicyRequest.policyArn() != null) {
            request.addParameter("PolicyArn", StringUtils.fromString((String)detachRolePolicyRequest.policyArn()));
        }
        return request;
    }
}

