/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.transform;

import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.iam.model.DetachGroupPolicyRequest;

public class DetachGroupPolicyRequestMarshaller
implements Marshaller<Request<DetachGroupPolicyRequest>, DetachGroupPolicyRequest> {
    public Request<DetachGroupPolicyRequest> marshall(DetachGroupPolicyRequest detachGroupPolicyRequest) {
        if (detachGroupPolicyRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)detachGroupPolicyRequest, "IAMClient");
        request.addParameter("Action", "DetachGroupPolicy");
        request.addParameter("Version", "2010-05-08");
        request.setHttpMethod(HttpMethodName.POST);
        if (detachGroupPolicyRequest.groupName() != null) {
            request.addParameter("GroupName", StringUtils.fromString((String)detachGroupPolicyRequest.groupName()));
        }
        if (detachGroupPolicyRequest.policyArn() != null) {
            request.addParameter("PolicyArn", StringUtils.fromString((String)detachGroupPolicyRequest.policyArn()));
        }
        return request;
    }
}

