/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.paginators;

import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.NextPageFetcher;
import software.amazon.awssdk.core.pagination.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.services.iam.IAMClient;
import software.amazon.awssdk.services.iam.model.ListPoliciesRequest;
import software.amazon.awssdk.services.iam.model.ListPoliciesResponse;
import software.amazon.awssdk.services.iam.model.Policy;

public final class ListPoliciesPaginator
implements SdkIterable<ListPoliciesResponse> {
    private final IAMClient client;
    private final ListPoliciesRequest firstRequest;
    private final NextPageFetcher nextPageFetcher;

    public ListPoliciesPaginator(IAMClient client, ListPoliciesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListPoliciesResponseFetcher();
    }

    public Iterator<ListPoliciesResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    public SdkIterable<Policy> policies() {
        Function<ListPoliciesResponse, Iterator> getIterator = response -> response != null ? response.policies().iterator() : null;
        return new PaginatedItemsIterable((SdkIterable)this, getIterator);
    }

    private class ListPoliciesResponseFetcher
    implements NextPageFetcher<ListPoliciesResponse> {
        private ListPoliciesResponseFetcher() {
        }

        public boolean hasNextPage(ListPoliciesResponse previousPage) {
            return previousPage.isTruncated();
        }

        public ListPoliciesResponse nextPage(ListPoliciesResponse previousPage) {
            if (previousPage == null) {
                return ListPoliciesPaginator.this.client.listPolicies(ListPoliciesPaginator.this.firstRequest);
            }
            return ListPoliciesPaginator.this.client.listPolicies((ListPoliciesRequest)((Object)ListPoliciesPaginator.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

