/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.paginators;

import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.NextPageFetcher;
import software.amazon.awssdk.core.pagination.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.services.iam.IAMClient;
import software.amazon.awssdk.services.iam.model.Group;
import software.amazon.awssdk.services.iam.model.ListGroupsRequest;
import software.amazon.awssdk.services.iam.model.ListGroupsResponse;

public final class ListGroupsPaginator
implements SdkIterable<ListGroupsResponse> {
    private final IAMClient client;
    private final ListGroupsRequest firstRequest;
    private final NextPageFetcher nextPageFetcher;

    public ListGroupsPaginator(IAMClient client, ListGroupsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListGroupsResponseFetcher();
    }

    public Iterator<ListGroupsResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    public SdkIterable<Group> groups() {
        Function<ListGroupsResponse, Iterator> getIterator = response -> response != null ? response.groups().iterator() : null;
        return new PaginatedItemsIterable((SdkIterable)this, getIterator);
    }

    private class ListGroupsResponseFetcher
    implements NextPageFetcher<ListGroupsResponse> {
        private ListGroupsResponseFetcher() {
        }

        public boolean hasNextPage(ListGroupsResponse previousPage) {
            return previousPage.isTruncated();
        }

        public ListGroupsResponse nextPage(ListGroupsResponse previousPage) {
            if (previousPage == null) {
                return ListGroupsPaginator.this.client.listGroups(ListGroupsPaginator.this.firstRequest);
            }
            return ListGroupsPaginator.this.client.listGroups((ListGroupsRequest)((Object)ListGroupsPaginator.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

