/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.paginators;

import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.NextPageFetcher;
import software.amazon.awssdk.core.pagination.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.services.iam.IAMClient;
import software.amazon.awssdk.services.iam.model.ListGroupPoliciesRequest;
import software.amazon.awssdk.services.iam.model.ListGroupPoliciesResponse;

public final class ListGroupPoliciesPaginator
implements SdkIterable<ListGroupPoliciesResponse> {
    private final IAMClient client;
    private final ListGroupPoliciesRequest firstRequest;
    private final NextPageFetcher nextPageFetcher;

    public ListGroupPoliciesPaginator(IAMClient client, ListGroupPoliciesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListGroupPoliciesResponseFetcher();
    }

    public Iterator<ListGroupPoliciesResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    public SdkIterable<String> policyNames() {
        Function<ListGroupPoliciesResponse, Iterator> getIterator = response -> response != null ? response.policyNames().iterator() : null;
        return new PaginatedItemsIterable((SdkIterable)this, getIterator);
    }

    private class ListGroupPoliciesResponseFetcher
    implements NextPageFetcher<ListGroupPoliciesResponse> {
        private ListGroupPoliciesResponseFetcher() {
        }

        public boolean hasNextPage(ListGroupPoliciesResponse previousPage) {
            return previousPage.isTruncated();
        }

        public ListGroupPoliciesResponse nextPage(ListGroupPoliciesResponse previousPage) {
            if (previousPage == null) {
                return ListGroupPoliciesPaginator.this.client.listGroupPolicies(ListGroupPoliciesPaginator.this.firstRequest);
            }
            return ListGroupPoliciesPaginator.this.client.listGroupPolicies((ListGroupPoliciesRequest)((Object)ListGroupPoliciesPaginator.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

