/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.paginators;

import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.NextPageFetcher;
import software.amazon.awssdk.core.pagination.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.services.iam.IAMClient;
import software.amazon.awssdk.services.iam.model.AttachedPolicy;
import software.amazon.awssdk.services.iam.model.ListAttachedGroupPoliciesRequest;
import software.amazon.awssdk.services.iam.model.ListAttachedGroupPoliciesResponse;

public final class ListAttachedGroupPoliciesPaginator
implements SdkIterable<ListAttachedGroupPoliciesResponse> {
    private final IAMClient client;
    private final ListAttachedGroupPoliciesRequest firstRequest;
    private final NextPageFetcher nextPageFetcher;

    public ListAttachedGroupPoliciesPaginator(IAMClient client, ListAttachedGroupPoliciesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListAttachedGroupPoliciesResponseFetcher();
    }

    public Iterator<ListAttachedGroupPoliciesResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    public SdkIterable<AttachedPolicy> attachedPolicies() {
        Function<ListAttachedGroupPoliciesResponse, Iterator> getIterator = response -> response != null ? response.attachedPolicies().iterator() : null;
        return new PaginatedItemsIterable((SdkIterable)this, getIterator);
    }

    private class ListAttachedGroupPoliciesResponseFetcher
    implements NextPageFetcher<ListAttachedGroupPoliciesResponse> {
        private ListAttachedGroupPoliciesResponseFetcher() {
        }

        public boolean hasNextPage(ListAttachedGroupPoliciesResponse previousPage) {
            return previousPage.isTruncated();
        }

        public ListAttachedGroupPoliciesResponse nextPage(ListAttachedGroupPoliciesResponse previousPage) {
            if (previousPage == null) {
                return ListAttachedGroupPoliciesPaginator.this.client.listAttachedGroupPolicies(ListAttachedGroupPoliciesPaginator.this.firstRequest);
            }
            return ListAttachedGroupPoliciesPaginator.this.client.listAttachedGroupPolicies((ListAttachedGroupPoliciesRequest)((Object)ListAttachedGroupPoliciesPaginator.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

