/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.services.iam.model.AttachedPolicy;
import software.amazon.awssdk.services.iam.model.PolicyDetail;
import software.amazon.awssdk.services.iam.model._attachedPoliciesListTypeCopier;
import software.amazon.awssdk.services.iam.model._groupNameListTypeCopier;
import software.amazon.awssdk.services.iam.model._policyDetailListTypeCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class UserDetail
implements ToCopyableBuilder<Builder, UserDetail> {
    private final String path;
    private final String userName;
    private final String userId;
    private final String arn;
    private final Instant createDate;
    private final List<PolicyDetail> userPolicyList;
    private final List<String> groupList;
    private final List<AttachedPolicy> attachedManagedPolicies;

    private UserDetail(BuilderImpl builder) {
        this.path = builder.path;
        this.userName = builder.userName;
        this.userId = builder.userId;
        this.arn = builder.arn;
        this.createDate = builder.createDate;
        this.userPolicyList = builder.userPolicyList;
        this.groupList = builder.groupList;
        this.attachedManagedPolicies = builder.attachedManagedPolicies;
    }

    public String path() {
        return this.path;
    }

    public String userName() {
        return this.userName;
    }

    public String userId() {
        return this.userId;
    }

    public String arn() {
        return this.arn;
    }

    public Instant createDate() {
        return this.createDate;
    }

    public List<PolicyDetail> userPolicyList() {
        return this.userPolicyList;
    }

    public List<String> groupList() {
        return this.groupList;
    }

    public List<AttachedPolicy> attachedManagedPolicies() {
        return this.attachedManagedPolicies;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.path());
        hashCode = 31 * hashCode + Objects.hashCode(this.userName());
        hashCode = 31 * hashCode + Objects.hashCode(this.userId());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.createDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.userPolicyList());
        hashCode = 31 * hashCode + Objects.hashCode(this.groupList());
        hashCode = 31 * hashCode + Objects.hashCode(this.attachedManagedPolicies());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UserDetail)) {
            return false;
        }
        UserDetail other = (UserDetail)obj;
        return Objects.equals(this.path(), other.path()) && Objects.equals(this.userName(), other.userName()) && Objects.equals(this.userId(), other.userId()) && Objects.equals(this.arn(), other.arn()) && Objects.equals(this.createDate(), other.createDate()) && Objects.equals(this.userPolicyList(), other.userPolicyList()) && Objects.equals(this.groupList(), other.groupList()) && Objects.equals(this.attachedManagedPolicies(), other.attachedManagedPolicies());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.path() != null) {
            sb.append("Path: ").append(this.path()).append(",");
        }
        if (this.userName() != null) {
            sb.append("UserName: ").append(this.userName()).append(",");
        }
        if (this.userId() != null) {
            sb.append("UserId: ").append(this.userId()).append(",");
        }
        if (this.arn() != null) {
            sb.append("Arn: ").append(this.arn()).append(",");
        }
        if (this.createDate() != null) {
            sb.append("CreateDate: ").append(this.createDate()).append(",");
        }
        if (this.userPolicyList() != null) {
            sb.append("UserPolicyList: ").append(this.userPolicyList()).append(",");
        }
        if (this.groupList() != null) {
            sb.append("GroupList: ").append(this.groupList()).append(",");
        }
        if (this.attachedManagedPolicies() != null) {
            sb.append("AttachedManagedPolicies: ").append(this.attachedManagedPolicies()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Path": {
                return Optional.of(clazz.cast(this.path()));
            }
            case "UserName": {
                return Optional.of(clazz.cast(this.userName()));
            }
            case "UserId": {
                return Optional.of(clazz.cast(this.userId()));
            }
            case "Arn": {
                return Optional.of(clazz.cast(this.arn()));
            }
            case "CreateDate": {
                return Optional.of(clazz.cast(this.createDate()));
            }
            case "UserPolicyList": {
                return Optional.of(clazz.cast(this.userPolicyList()));
            }
            case "GroupList": {
                return Optional.of(clazz.cast(this.groupList()));
            }
            case "AttachedManagedPolicies": {
                return Optional.of(clazz.cast(this.attachedManagedPolicies()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String path;
        private String userName;
        private String userId;
        private String arn;
        private Instant createDate;
        private List<PolicyDetail> userPolicyList;
        private List<String> groupList;
        private List<AttachedPolicy> attachedManagedPolicies;

        private BuilderImpl() {
        }

        private BuilderImpl(UserDetail model) {
            this.path(model.path);
            this.userName(model.userName);
            this.userId(model.userId);
            this.arn(model.arn);
            this.createDate(model.createDate);
            this.userPolicyList(model.userPolicyList);
            this.groupList(model.groupList);
            this.attachedManagedPolicies(model.attachedManagedPolicies);
        }

        public final String getPath() {
            return this.path;
        }

        @Override
        public final Builder path(String path) {
            this.path = path;
            return this;
        }

        public final void setPath(String path) {
            this.path = path;
        }

        public final String getUserName() {
            return this.userName;
        }

        @Override
        public final Builder userName(String userName) {
            this.userName = userName;
            return this;
        }

        public final void setUserName(String userName) {
            this.userName = userName;
        }

        public final String getUserId() {
            return this.userId;
        }

        @Override
        public final Builder userId(String userId) {
            this.userId = userId;
            return this;
        }

        public final void setUserId(String userId) {
            this.userId = userId;
        }

        public final String getArn() {
            return this.arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final Instant getCreateDate() {
            return this.createDate;
        }

        @Override
        public final Builder createDate(Instant createDate) {
            this.createDate = createDate;
            return this;
        }

        public final void setCreateDate(Instant createDate) {
            this.createDate = createDate;
        }

        public final Collection<PolicyDetail.Builder> getUserPolicyList() {
            return this.userPolicyList != null ? (Collection)this.userPolicyList.stream().map(PolicyDetail::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder userPolicyList(Collection<PolicyDetail> userPolicyList) {
            this.userPolicyList = _policyDetailListTypeCopier.copy(userPolicyList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder userPolicyList(PolicyDetail ... userPolicyList) {
            this.userPolicyList(Arrays.asList(userPolicyList));
            return this;
        }

        public final void setUserPolicyList(Collection<PolicyDetail.BuilderImpl> userPolicyList) {
            this.userPolicyList = _policyDetailListTypeCopier.copyFromBuilder(userPolicyList);
        }

        public final Collection<String> getGroupList() {
            return this.groupList;
        }

        @Override
        public final Builder groupList(Collection<String> groupList) {
            this.groupList = _groupNameListTypeCopier.copy(groupList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groupList(String ... groupList) {
            this.groupList(Arrays.asList(groupList));
            return this;
        }

        public final void setGroupList(Collection<String> groupList) {
            this.groupList = _groupNameListTypeCopier.copy(groupList);
        }

        public final Collection<AttachedPolicy.Builder> getAttachedManagedPolicies() {
            return this.attachedManagedPolicies != null ? (Collection)this.attachedManagedPolicies.stream().map(AttachedPolicy::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder attachedManagedPolicies(Collection<AttachedPolicy> attachedManagedPolicies) {
            this.attachedManagedPolicies = _attachedPoliciesListTypeCopier.copy(attachedManagedPolicies);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attachedManagedPolicies(AttachedPolicy ... attachedManagedPolicies) {
            this.attachedManagedPolicies(Arrays.asList(attachedManagedPolicies));
            return this;
        }

        public final void setAttachedManagedPolicies(Collection<AttachedPolicy.BuilderImpl> attachedManagedPolicies) {
            this.attachedManagedPolicies = _attachedPoliciesListTypeCopier.copyFromBuilder(attachedManagedPolicies);
        }

        public UserDetail build() {
            return new UserDetail(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, UserDetail> {
        public Builder path(String var1);

        public Builder userName(String var1);

        public Builder userId(String var1);

        public Builder arn(String var1);

        public Builder createDate(Instant var1);

        public Builder userPolicyList(Collection<PolicyDetail> var1);

        public Builder userPolicyList(PolicyDetail ... var1);

        public Builder groupList(Collection<String> var1);

        public Builder groupList(String ... var1);

        public Builder attachedManagedPolicies(Collection<AttachedPolicy> var1);

        public Builder attachedManagedPolicies(AttachedPolicy ... var1);
    }
}

