/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.services.iam.model.PolicyScopeType;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListPoliciesRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, ListPoliciesRequest> {
    private final String scope;
    private final Boolean onlyAttached;
    private final String pathPrefix;
    private final String marker;
    private final Integer maxItems;

    private ListPoliciesRequest(BuilderImpl builder) {
        this.scope = builder.scope;
        this.onlyAttached = builder.onlyAttached;
        this.pathPrefix = builder.pathPrefix;
        this.marker = builder.marker;
        this.maxItems = builder.maxItems;
    }

    public PolicyScopeType scope() {
        return PolicyScopeType.fromValue(this.scope);
    }

    public String scopeString() {
        return this.scope;
    }

    public Boolean onlyAttached() {
        return this.onlyAttached;
    }

    public String pathPrefix() {
        return this.pathPrefix;
    }

    public String marker() {
        return this.marker;
    }

    public Integer maxItems() {
        return this.maxItems;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.scopeString());
        hashCode = 31 * hashCode + Objects.hashCode(this.onlyAttached());
        hashCode = 31 * hashCode + Objects.hashCode(this.pathPrefix());
        hashCode = 31 * hashCode + Objects.hashCode(this.marker());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxItems());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListPoliciesRequest)) {
            return false;
        }
        ListPoliciesRequest other = (ListPoliciesRequest)((Object)obj);
        return Objects.equals(this.scopeString(), other.scopeString()) && Objects.equals(this.onlyAttached(), other.onlyAttached()) && Objects.equals(this.pathPrefix(), other.pathPrefix()) && Objects.equals(this.marker(), other.marker()) && Objects.equals(this.maxItems(), other.maxItems());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.scopeString() != null) {
            sb.append("Scope: ").append(this.scopeString()).append(",");
        }
        if (this.onlyAttached() != null) {
            sb.append("OnlyAttached: ").append(this.onlyAttached()).append(",");
        }
        if (this.pathPrefix() != null) {
            sb.append("PathPrefix: ").append(this.pathPrefix()).append(",");
        }
        if (this.marker() != null) {
            sb.append("Marker: ").append(this.marker()).append(",");
        }
        if (this.maxItems() != null) {
            sb.append("MaxItems: ").append(this.maxItems()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Scope": {
                return Optional.of(clazz.cast(this.scopeString()));
            }
            case "OnlyAttached": {
                return Optional.of(clazz.cast(this.onlyAttached()));
            }
            case "PathPrefix": {
                return Optional.of(clazz.cast(this.pathPrefix()));
            }
            case "Marker": {
                return Optional.of(clazz.cast(this.marker()));
            }
            case "MaxItems": {
                return Optional.of(clazz.cast(this.maxItems()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String scope;
        private Boolean onlyAttached;
        private String pathPrefix;
        private String marker;
        private Integer maxItems;

        private BuilderImpl() {
        }

        private BuilderImpl(ListPoliciesRequest model) {
            this.scope(model.scope);
            this.onlyAttached(model.onlyAttached);
            this.pathPrefix(model.pathPrefix);
            this.marker(model.marker);
            this.maxItems(model.maxItems);
        }

        public final String getScope() {
            return this.scope;
        }

        @Override
        public final Builder scope(String scope) {
            this.scope = scope;
            return this;
        }

        @Override
        public final Builder scope(PolicyScopeType scope) {
            this.scope(scope.toString());
            return this;
        }

        public final void setScope(String scope) {
            this.scope = scope;
        }

        public final Boolean getOnlyAttached() {
            return this.onlyAttached;
        }

        @Override
        public final Builder onlyAttached(Boolean onlyAttached) {
            this.onlyAttached = onlyAttached;
            return this;
        }

        public final void setOnlyAttached(Boolean onlyAttached) {
            this.onlyAttached = onlyAttached;
        }

        public final String getPathPrefix() {
            return this.pathPrefix;
        }

        @Override
        public final Builder pathPrefix(String pathPrefix) {
            this.pathPrefix = pathPrefix;
            return this;
        }

        public final void setPathPrefix(String pathPrefix) {
            this.pathPrefix = pathPrefix;
        }

        public final String getMarker() {
            return this.marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        public final Integer getMaxItems() {
            return this.maxItems;
        }

        @Override
        public final Builder maxItems(Integer maxItems) {
            this.maxItems = maxItems;
            return this;
        }

        public final void setMaxItems(Integer maxItems) {
            this.maxItems = maxItems;
        }

        public ListPoliciesRequest build() {
            return new ListPoliciesRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ListPoliciesRequest> {
        public Builder scope(String var1);

        public Builder scope(PolicyScopeType var1);

        public Builder onlyAttached(Boolean var1);

        public Builder pathPrefix(String var1);

        public Builder marker(String var1);

        public Builder maxItems(Integer var1);
    }
}

