/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.services.iam.model.MFADevice;
import software.amazon.awssdk.services.iam.model._mfaDeviceListTypeCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListMFADevicesResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, ListMFADevicesResponse> {
    private final List<MFADevice> mfaDevices;
    private final Boolean isTruncated;
    private final String marker;

    private ListMFADevicesResponse(BuilderImpl builder) {
        this.mfaDevices = builder.mfaDevices;
        this.isTruncated = builder.isTruncated;
        this.marker = builder.marker;
    }

    public List<MFADevice> mfaDevices() {
        return this.mfaDevices;
    }

    public Boolean isTruncated() {
        return this.isTruncated;
    }

    public String marker() {
        return this.marker;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.mfaDevices());
        hashCode = 31 * hashCode + Objects.hashCode(this.isTruncated());
        hashCode = 31 * hashCode + Objects.hashCode(this.marker());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListMFADevicesResponse)) {
            return false;
        }
        ListMFADevicesResponse other = (ListMFADevicesResponse)((Object)obj);
        return Objects.equals(this.mfaDevices(), other.mfaDevices()) && Objects.equals(this.isTruncated(), other.isTruncated()) && Objects.equals(this.marker(), other.marker());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.mfaDevices() != null) {
            sb.append("MFADevices: ").append(this.mfaDevices()).append(",");
        }
        if (this.isTruncated() != null) {
            sb.append("IsTruncated: ").append(this.isTruncated()).append(",");
        }
        if (this.marker() != null) {
            sb.append("Marker: ").append(this.marker()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MFADevices": {
                return Optional.of(clazz.cast(this.mfaDevices()));
            }
            case "IsTruncated": {
                return Optional.of(clazz.cast(this.isTruncated()));
            }
            case "Marker": {
                return Optional.of(clazz.cast(this.marker()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private List<MFADevice> mfaDevices;
        private Boolean isTruncated;
        private String marker;

        private BuilderImpl() {
        }

        private BuilderImpl(ListMFADevicesResponse model) {
            this.mfaDevices(model.mfaDevices);
            this.isTruncated(model.isTruncated);
            this.marker(model.marker);
        }

        public final Collection<MFADevice.Builder> getMFADevices() {
            return this.mfaDevices != null ? (Collection)this.mfaDevices.stream().map(MFADevice::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder mfaDevices(Collection<MFADevice> mfaDevices) {
            this.mfaDevices = _mfaDeviceListTypeCopier.copy(mfaDevices);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder mfaDevices(MFADevice ... mfaDevices) {
            this.mfaDevices(Arrays.asList(mfaDevices));
            return this;
        }

        public final void setMFADevices(Collection<MFADevice.BuilderImpl> mfaDevices) {
            this.mfaDevices = _mfaDeviceListTypeCopier.copyFromBuilder(mfaDevices);
        }

        public final Boolean getIsTruncated() {
            return this.isTruncated;
        }

        @Override
        public final Builder isTruncated(Boolean isTruncated) {
            this.isTruncated = isTruncated;
            return this;
        }

        public final void setIsTruncated(Boolean isTruncated) {
            this.isTruncated = isTruncated;
        }

        public final String getMarker() {
            return this.marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        public ListMFADevicesResponse build() {
            return new ListMFADevicesResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ListMFADevicesResponse> {
        public Builder mfaDevices(Collection<MFADevice> var1);

        public Builder mfaDevices(MFADevice ... var1);

        public Builder isTruncated(Boolean var1);

        public Builder marker(String var1);
    }
}

