/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.model;

import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.core.runtime.TypeConverter;
import software.amazon.awssdk.services.iam.model.SummaryKeyType;
import software.amazon.awssdk.services.iam.model._summaryMapTypeCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class GetAccountSummaryResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, GetAccountSummaryResponse> {
    private final Map<String, Integer> summaryMap;

    private GetAccountSummaryResponse(BuilderImpl builder) {
        this.summaryMap = builder.summaryMap;
    }

    public Map<SummaryKeyType, Integer> summaryMap() {
        return TypeConverter.convert(this.summaryMap, SummaryKeyType::fromValue, Function.identity(), (k, v) -> !Objects.equals(k, (Object)SummaryKeyType.UNKNOWN_TO_SDK_VERSION));
    }

    public Map<String, Integer> summaryMapStrings() {
        return this.summaryMap;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.summaryMapStrings());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetAccountSummaryResponse)) {
            return false;
        }
        GetAccountSummaryResponse other = (GetAccountSummaryResponse)((Object)obj);
        return Objects.equals(this.summaryMapStrings(), other.summaryMapStrings());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.summaryMapStrings() != null) {
            sb.append("SummaryMap: ").append(this.summaryMapStrings()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SummaryMap": {
                return Optional.of(clazz.cast(this.summaryMapStrings()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private Map<String, Integer> summaryMap;

        private BuilderImpl() {
        }

        private BuilderImpl(GetAccountSummaryResponse model) {
            this.summaryMap(model.summaryMap);
        }

        public final Map<String, Integer> getSummaryMap() {
            return this.summaryMap;
        }

        @Override
        public final Builder summaryMap(Map<String, Integer> summaryMap) {
            this.summaryMap = _summaryMapTypeCopier.copy(summaryMap);
            return this;
        }

        public final void setSummaryMap(Map<String, Integer> summaryMap) {
            this.summaryMap = _summaryMapTypeCopier.copy(summaryMap);
        }

        public GetAccountSummaryResponse build() {
            return new GetAccountSummaryResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, GetAccountSummaryResponse> {
        public Builder summaryMap(Map<String, Integer> var1);
    }
}

