/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.runtime.TypeConverter;
import software.amazon.awssdk.services.iam.model.ContextKeyNamesResultListTypeCopier;
import software.amazon.awssdk.services.iam.model.EvalDecisionDetailsTypeCopier;
import software.amazon.awssdk.services.iam.model.OrganizationsDecisionDetail;
import software.amazon.awssdk.services.iam.model.PolicyEvaluationDecisionType;
import software.amazon.awssdk.services.iam.model.ResourceSpecificResult;
import software.amazon.awssdk.services.iam.model.ResourceSpecificResultListTypeCopier;
import software.amazon.awssdk.services.iam.model.Statement;
import software.amazon.awssdk.services.iam.model.StatementListTypeCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class EvaluationResult
implements ToCopyableBuilder<Builder, EvaluationResult> {
    private final String evalActionName;
    private final String evalResourceName;
    private final String evalDecision;
    private final List<Statement> matchedStatements;
    private final List<String> missingContextValues;
    private final OrganizationsDecisionDetail organizationsDecisionDetail;
    private final Map<String, String> evalDecisionDetails;
    private final List<ResourceSpecificResult> resourceSpecificResults;

    private EvaluationResult(BuilderImpl builder) {
        this.evalActionName = builder.evalActionName;
        this.evalResourceName = builder.evalResourceName;
        this.evalDecision = builder.evalDecision;
        this.matchedStatements = builder.matchedStatements;
        this.missingContextValues = builder.missingContextValues;
        this.organizationsDecisionDetail = builder.organizationsDecisionDetail;
        this.evalDecisionDetails = builder.evalDecisionDetails;
        this.resourceSpecificResults = builder.resourceSpecificResults;
    }

    public String evalActionName() {
        return this.evalActionName;
    }

    public String evalResourceName() {
        return this.evalResourceName;
    }

    public PolicyEvaluationDecisionType evalDecision() {
        return PolicyEvaluationDecisionType.fromValue(this.evalDecision);
    }

    public String evalDecisionString() {
        return this.evalDecision;
    }

    public List<Statement> matchedStatements() {
        return this.matchedStatements;
    }

    public List<String> missingContextValues() {
        return this.missingContextValues;
    }

    public OrganizationsDecisionDetail organizationsDecisionDetail() {
        return this.organizationsDecisionDetail;
    }

    public Map<String, PolicyEvaluationDecisionType> evalDecisionDetails() {
        return TypeConverter.convert(this.evalDecisionDetails, Function.identity(), PolicyEvaluationDecisionType::fromValue, (k, v) -> true);
    }

    public Map<String, String> evalDecisionDetailsStrings() {
        return this.evalDecisionDetails;
    }

    public List<ResourceSpecificResult> resourceSpecificResults() {
        return this.resourceSpecificResults;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.evalActionName());
        hashCode = 31 * hashCode + Objects.hashCode(this.evalResourceName());
        hashCode = 31 * hashCode + Objects.hashCode(this.evalDecisionString());
        hashCode = 31 * hashCode + Objects.hashCode(this.matchedStatements());
        hashCode = 31 * hashCode + Objects.hashCode(this.missingContextValues());
        hashCode = 31 * hashCode + Objects.hashCode(this.organizationsDecisionDetail());
        hashCode = 31 * hashCode + Objects.hashCode(this.evalDecisionDetailsStrings());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceSpecificResults());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EvaluationResult)) {
            return false;
        }
        EvaluationResult other = (EvaluationResult)obj;
        return Objects.equals(this.evalActionName(), other.evalActionName()) && Objects.equals(this.evalResourceName(), other.evalResourceName()) && Objects.equals(this.evalDecisionString(), other.evalDecisionString()) && Objects.equals(this.matchedStatements(), other.matchedStatements()) && Objects.equals(this.missingContextValues(), other.missingContextValues()) && Objects.equals(this.organizationsDecisionDetail(), other.organizationsDecisionDetail()) && Objects.equals(this.evalDecisionDetailsStrings(), other.evalDecisionDetailsStrings()) && Objects.equals(this.resourceSpecificResults(), other.resourceSpecificResults());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.evalActionName() != null) {
            sb.append("EvalActionName: ").append(this.evalActionName()).append(",");
        }
        if (this.evalResourceName() != null) {
            sb.append("EvalResourceName: ").append(this.evalResourceName()).append(",");
        }
        if (this.evalDecisionString() != null) {
            sb.append("EvalDecision: ").append(this.evalDecisionString()).append(",");
        }
        if (this.matchedStatements() != null) {
            sb.append("MatchedStatements: ").append(this.matchedStatements()).append(",");
        }
        if (this.missingContextValues() != null) {
            sb.append("MissingContextValues: ").append(this.missingContextValues()).append(",");
        }
        if (this.organizationsDecisionDetail() != null) {
            sb.append("OrganizationsDecisionDetail: ").append(this.organizationsDecisionDetail()).append(",");
        }
        if (this.evalDecisionDetailsStrings() != null) {
            sb.append("EvalDecisionDetails: ").append(this.evalDecisionDetailsStrings()).append(",");
        }
        if (this.resourceSpecificResults() != null) {
            sb.append("ResourceSpecificResults: ").append(this.resourceSpecificResults()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EvalActionName": {
                return Optional.of(clazz.cast(this.evalActionName()));
            }
            case "EvalResourceName": {
                return Optional.of(clazz.cast(this.evalResourceName()));
            }
            case "EvalDecision": {
                return Optional.of(clazz.cast(this.evalDecisionString()));
            }
            case "MatchedStatements": {
                return Optional.of(clazz.cast(this.matchedStatements()));
            }
            case "MissingContextValues": {
                return Optional.of(clazz.cast(this.missingContextValues()));
            }
            case "OrganizationsDecisionDetail": {
                return Optional.of(clazz.cast(this.organizationsDecisionDetail()));
            }
            case "EvalDecisionDetails": {
                return Optional.of(clazz.cast(this.evalDecisionDetailsStrings()));
            }
            case "ResourceSpecificResults": {
                return Optional.of(clazz.cast(this.resourceSpecificResults()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String evalActionName;
        private String evalResourceName;
        private String evalDecision;
        private List<Statement> matchedStatements;
        private List<String> missingContextValues;
        private OrganizationsDecisionDetail organizationsDecisionDetail;
        private Map<String, String> evalDecisionDetails;
        private List<ResourceSpecificResult> resourceSpecificResults;

        private BuilderImpl() {
        }

        private BuilderImpl(EvaluationResult model) {
            this.evalActionName(model.evalActionName);
            this.evalResourceName(model.evalResourceName);
            this.evalDecision(model.evalDecision);
            this.matchedStatements(model.matchedStatements);
            this.missingContextValues(model.missingContextValues);
            this.organizationsDecisionDetail(model.organizationsDecisionDetail);
            this.evalDecisionDetails(model.evalDecisionDetails);
            this.resourceSpecificResults(model.resourceSpecificResults);
        }

        public final String getEvalActionName() {
            return this.evalActionName;
        }

        @Override
        public final Builder evalActionName(String evalActionName) {
            this.evalActionName = evalActionName;
            return this;
        }

        public final void setEvalActionName(String evalActionName) {
            this.evalActionName = evalActionName;
        }

        public final String getEvalResourceName() {
            return this.evalResourceName;
        }

        @Override
        public final Builder evalResourceName(String evalResourceName) {
            this.evalResourceName = evalResourceName;
            return this;
        }

        public final void setEvalResourceName(String evalResourceName) {
            this.evalResourceName = evalResourceName;
        }

        public final String getEvalDecision() {
            return this.evalDecision;
        }

        @Override
        public final Builder evalDecision(String evalDecision) {
            this.evalDecision = evalDecision;
            return this;
        }

        @Override
        public final Builder evalDecision(PolicyEvaluationDecisionType evalDecision) {
            this.evalDecision(evalDecision.toString());
            return this;
        }

        public final void setEvalDecision(String evalDecision) {
            this.evalDecision = evalDecision;
        }

        public final Collection<Statement.Builder> getMatchedStatements() {
            return this.matchedStatements != null ? (Collection)this.matchedStatements.stream().map(Statement::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder matchedStatements(Collection<Statement> matchedStatements) {
            this.matchedStatements = StatementListTypeCopier.copy(matchedStatements);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder matchedStatements(Statement ... matchedStatements) {
            this.matchedStatements(Arrays.asList(matchedStatements));
            return this;
        }

        public final void setMatchedStatements(Collection<Statement.BuilderImpl> matchedStatements) {
            this.matchedStatements = StatementListTypeCopier.copyFromBuilder(matchedStatements);
        }

        public final Collection<String> getMissingContextValues() {
            return this.missingContextValues;
        }

        @Override
        public final Builder missingContextValues(Collection<String> missingContextValues) {
            this.missingContextValues = ContextKeyNamesResultListTypeCopier.copy(missingContextValues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder missingContextValues(String ... missingContextValues) {
            this.missingContextValues(Arrays.asList(missingContextValues));
            return this;
        }

        public final void setMissingContextValues(Collection<String> missingContextValues) {
            this.missingContextValues = ContextKeyNamesResultListTypeCopier.copy(missingContextValues);
        }

        public final OrganizationsDecisionDetail.Builder getOrganizationsDecisionDetail() {
            return this.organizationsDecisionDetail != null ? this.organizationsDecisionDetail.toBuilder() : null;
        }

        @Override
        public final Builder organizationsDecisionDetail(OrganizationsDecisionDetail organizationsDecisionDetail) {
            this.organizationsDecisionDetail = organizationsDecisionDetail;
            return this;
        }

        public final void setOrganizationsDecisionDetail(OrganizationsDecisionDetail.BuilderImpl organizationsDecisionDetail) {
            this.organizationsDecisionDetail = organizationsDecisionDetail != null ? organizationsDecisionDetail.build() : null;
        }

        public final Map<String, String> getEvalDecisionDetails() {
            return this.evalDecisionDetails;
        }

        @Override
        public final Builder evalDecisionDetails(Map<String, String> evalDecisionDetails) {
            this.evalDecisionDetails = EvalDecisionDetailsTypeCopier.copy(evalDecisionDetails);
            return this;
        }

        public final void setEvalDecisionDetails(Map<String, String> evalDecisionDetails) {
            this.evalDecisionDetails = EvalDecisionDetailsTypeCopier.copy(evalDecisionDetails);
        }

        public final Collection<ResourceSpecificResult.Builder> getResourceSpecificResults() {
            return this.resourceSpecificResults != null ? (Collection)this.resourceSpecificResults.stream().map(ResourceSpecificResult::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder resourceSpecificResults(Collection<ResourceSpecificResult> resourceSpecificResults) {
            this.resourceSpecificResults = ResourceSpecificResultListTypeCopier.copy(resourceSpecificResults);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceSpecificResults(ResourceSpecificResult ... resourceSpecificResults) {
            this.resourceSpecificResults(Arrays.asList(resourceSpecificResults));
            return this;
        }

        public final void setResourceSpecificResults(Collection<ResourceSpecificResult.BuilderImpl> resourceSpecificResults) {
            this.resourceSpecificResults = ResourceSpecificResultListTypeCopier.copyFromBuilder(resourceSpecificResults);
        }

        public EvaluationResult build() {
            return new EvaluationResult(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, EvaluationResult> {
        public Builder evalActionName(String var1);

        public Builder evalResourceName(String var1);

        public Builder evalDecision(String var1);

        public Builder evalDecision(PolicyEvaluationDecisionType var1);

        public Builder matchedStatements(Collection<Statement> var1);

        public Builder matchedStatements(Statement ... var1);

        public Builder missingContextValues(Collection<String> var1);

        public Builder missingContextValues(String ... var1);

        public Builder organizationsDecisionDetail(OrganizationsDecisionDetail var1);

        default public Builder organizationsDecisionDetail(Consumer<OrganizationsDecisionDetail.Builder> organizationsDecisionDetail) {
            return this.organizationsDecisionDetail((OrganizationsDecisionDetail)((OrganizationsDecisionDetail.Builder)OrganizationsDecisionDetail.builder().apply(organizationsDecisionDetail)).build());
        }

        public Builder evalDecisionDetails(Map<String, String> var1);

        public Builder resourceSpecificResults(Collection<ResourceSpecificResult> var1);

        public Builder resourceSpecificResults(ResourceSpecificResult ... var1);
    }
}

