/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class EnableMFADeviceRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, EnableMFADeviceRequest> {
    private final String userName;
    private final String serialNumber;
    private final String authenticationCode1;
    private final String authenticationCode2;

    private EnableMFADeviceRequest(BuilderImpl builder) {
        this.userName = builder.userName;
        this.serialNumber = builder.serialNumber;
        this.authenticationCode1 = builder.authenticationCode1;
        this.authenticationCode2 = builder.authenticationCode2;
    }

    public String userName() {
        return this.userName;
    }

    public String serialNumber() {
        return this.serialNumber;
    }

    public String authenticationCode1() {
        return this.authenticationCode1;
    }

    public String authenticationCode2() {
        return this.authenticationCode2;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.userName());
        hashCode = 31 * hashCode + Objects.hashCode(this.serialNumber());
        hashCode = 31 * hashCode + Objects.hashCode(this.authenticationCode1());
        hashCode = 31 * hashCode + Objects.hashCode(this.authenticationCode2());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EnableMFADeviceRequest)) {
            return false;
        }
        EnableMFADeviceRequest other = (EnableMFADeviceRequest)((Object)obj);
        return Objects.equals(this.userName(), other.userName()) && Objects.equals(this.serialNumber(), other.serialNumber()) && Objects.equals(this.authenticationCode1(), other.authenticationCode1()) && Objects.equals(this.authenticationCode2(), other.authenticationCode2());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.userName() != null) {
            sb.append("UserName: ").append(this.userName()).append(",");
        }
        if (this.serialNumber() != null) {
            sb.append("SerialNumber: ").append(this.serialNumber()).append(",");
        }
        if (this.authenticationCode1() != null) {
            sb.append("AuthenticationCode1: ").append(this.authenticationCode1()).append(",");
        }
        if (this.authenticationCode2() != null) {
            sb.append("AuthenticationCode2: ").append(this.authenticationCode2()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "UserName": {
                return Optional.of(clazz.cast(this.userName()));
            }
            case "SerialNumber": {
                return Optional.of(clazz.cast(this.serialNumber()));
            }
            case "AuthenticationCode1": {
                return Optional.of(clazz.cast(this.authenticationCode1()));
            }
            case "AuthenticationCode2": {
                return Optional.of(clazz.cast(this.authenticationCode2()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String userName;
        private String serialNumber;
        private String authenticationCode1;
        private String authenticationCode2;

        private BuilderImpl() {
        }

        private BuilderImpl(EnableMFADeviceRequest model) {
            this.userName(model.userName);
            this.serialNumber(model.serialNumber);
            this.authenticationCode1(model.authenticationCode1);
            this.authenticationCode2(model.authenticationCode2);
        }

        public final String getUserName() {
            return this.userName;
        }

        @Override
        public final Builder userName(String userName) {
            this.userName = userName;
            return this;
        }

        public final void setUserName(String userName) {
            this.userName = userName;
        }

        public final String getSerialNumber() {
            return this.serialNumber;
        }

        @Override
        public final Builder serialNumber(String serialNumber) {
            this.serialNumber = serialNumber;
            return this;
        }

        public final void setSerialNumber(String serialNumber) {
            this.serialNumber = serialNumber;
        }

        public final String getAuthenticationCode1() {
            return this.authenticationCode1;
        }

        @Override
        public final Builder authenticationCode1(String authenticationCode1) {
            this.authenticationCode1 = authenticationCode1;
            return this;
        }

        public final void setAuthenticationCode1(String authenticationCode1) {
            this.authenticationCode1 = authenticationCode1;
        }

        public final String getAuthenticationCode2() {
            return this.authenticationCode2;
        }

        @Override
        public final Builder authenticationCode2(String authenticationCode2) {
            this.authenticationCode2 = authenticationCode2;
            return this;
        }

        public final void setAuthenticationCode2(String authenticationCode2) {
            this.authenticationCode2 = authenticationCode2;
        }

        public EnableMFADeviceRequest build() {
            return new EnableMFADeviceRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, EnableMFADeviceRequest> {
        public Builder userName(String var1);

        public Builder serialNumber(String var1);

        public Builder authenticationCode1(String var1);

        public Builder authenticationCode2(String var1);
    }
}

