/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.transform;

import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.iam.model.UpdateServiceSpecificCredentialRequest;

public class UpdateServiceSpecificCredentialRequestMarshaller
implements Marshaller<Request<UpdateServiceSpecificCredentialRequest>, UpdateServiceSpecificCredentialRequest> {
    public Request<UpdateServiceSpecificCredentialRequest> marshall(UpdateServiceSpecificCredentialRequest updateServiceSpecificCredentialRequest) {
        if (updateServiceSpecificCredentialRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)updateServiceSpecificCredentialRequest, "IAMClient");
        request.addParameter("Action", "UpdateServiceSpecificCredential");
        request.addParameter("Version", "2010-05-08");
        request.setHttpMethod(HttpMethodName.POST);
        if (updateServiceSpecificCredentialRequest.userName() != null) {
            request.addParameter("UserName", StringUtils.fromString((String)updateServiceSpecificCredentialRequest.userName()));
        }
        if (updateServiceSpecificCredentialRequest.serviceSpecificCredentialId() != null) {
            request.addParameter("ServiceSpecificCredentialId", StringUtils.fromString((String)updateServiceSpecificCredentialRequest.serviceSpecificCredentialId()));
        }
        if (updateServiceSpecificCredentialRequest.statusString() != null) {
            request.addParameter("Status", StringUtils.fromString((String)updateServiceSpecificCredentialRequest.statusString()));
        }
        return request;
    }
}

